ORCA/M Asm65816 2.1.0

0001 81C2                       TITLE 'Control Panel Int Handler'
0002 81C2
0003 81C2              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 81C2              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 5:21:42 PM
0005 81C2
0006 81C2              ******************************************************
0007 81C2              *                                                    *
0008 81C2              *    Int Handler for Control Panel Desk Accessory    *
0009 81C2              *                                                    *
0010 81C2              *                         by                         *
0011 81C2              *               Fern Bachman     1985-1987           *
0012 81C2              *               Joe Bo           1987-1989           *
0013 81C2              *                                                    *
0014 81C2              *       Copyright Apple Computer, Inc. 1985-1989     *
0015 81C2              *                All Rights Reserved.                *
0016 81C2              *                                                    *
0017 81C2              ******************************************************
0018 81C2
0019 81C2
0020 81C2              * CPINTHNDLR handles one second interrupts.
0021 81C2              * Its purpose is to update the clock box
0022 81C2              * on screens which require the clock box.
0023 81C2              * No action is taken on screens which do not
0024 81C2              * display the clock box.
0025 81C2
0026 81C2              CPINTHNDLR EQU   *
0027 81C2 20 F9 81              JSR   SAVESHOLES               ;Save screen holes
0028 81C5 D4 28                 PEI   BASL                     ;Save monitor variables
0029 81C7 D4 24                 PEI   CH                       ;
0030 81C9
0031 81C9 A6 00                 LDX   CURSCRN                  ;Which screen we on?
0032 81CB 30 1A                 BMI   @1                       ;BRA for special password display 
0033 81CD BF 2D 83 FF           LDA   >STATTBL,X               ;Get status byte
0034 81D1 0A                    ASL   A                        ;Bit 5 has data
0035 81D2 0A                    ASL   A                        ; so shift it to bit 7 for testing.
0036 81D3 10 12                 BPL   @1                       ;'+' then no clock box required
0037 81D5 9C 7B 04              STZ   OLDCH                    ;Force 80 column firmware to use new CH
0038 81D8 A5 32                 LDA   INVFLG                   ;=FF then normal printing
0039 81DA 48                    PHA                            ;Save for later testing
0040 81DB 20 11 9A              JSR   TURNONMTXT               ;Enable normal mouse text printing
0041 81DE 20 65 94              JSR   PRINTCLK0                ;Change clock box contents
0042 81E1 68                    PLA                            ;Recall state of mouse text printing
0043 81E2 30 03                 BMI   @1                       ;Continue normally if '-'
0044 81E4 20 20 9A              JSR   TURNOFFMTXT              ;<>= then set inv print + no mouse text
0045 81E7
0046 81E7              @1       EQU   *                        ;Clear interrupt/clean up/exit
0047 81E7 C2 30                 REP   #$30                     ;16 bit mode to save a few bytes
0048 81E9 68                    PLA                            ;
0049 81EA 85 24                 STA   CH                       ;Restore monitor variables
0050 81EC 68                    PLA                            ;
0051 81ED 85 28                 STA   BASL                     ;
0052 81EF E2 30                 SEP   #$30                     ;Back to monitor world
0053 81F1 20 FC 81              JSR   RSTRSHOLES               ;Restore screen holes
0054 81F4 9C 32 C0              STZ   SCANINT                  ;Reset bit 6 to clear 1 second interrupt
0055 81F7 18                    CLC                            ;Clear 'c' to indicate serviced
0056 81F8 6B                    RTL                            ;Back to interrupt handler
0057 81F9
0058 81F9
0059 81F9              SAVESHOLES EQU   *                      ;Enter here to save slt 0/3 scrn holes
0060 81F9 E2 40                 SEP   #$40                     ;'v'=1 if saving screen holes
0061 81FB 50                    OPCODE BVC                     ;Branch never taken
0062 81FC
0063 81FC              RSTRSHOLES EQU   *                      ;Enter here to restore slt 0/3 scrn holes
0064 81FC B8                    CLV                            ;'v'=0 if restoring screen holes
0065 81FD A2 00                 LDX   #$00                     ;Start with 1st location in buffer
0066 81FF A0 78                 LDY   #$78                     ;Low byte of screen hole
0067 8201              @1       EQU   *
0068 8201 A9 04                 LDA   #$04                     ;Start with 1st screen hole
0069 8203 84 09                 STY   ZINT+0                   ;
0070 8205              @2       EQU   *
0071 8205 85 0A                 STA   ZINT+1                   ;Interrupt pointer
0072 8207 A0 00                 LDY   #$00                     ;Start with 1st screen hole
0073 8209 50 06                 BVC   @3                       ;'v'=0 then restoring screen holes
0074 820B B1 09                 LDA   (ZINT),Y                 ;Get screen hole
0075 820D 95 0B                 STA   ZINTSHBUF,X              ;Save in zero page int scrn hole buffer
0076 820F 80 04                 BRA   @4                       ;
0077 8211
0078 8211              @3       EQU   *
0079 8211 B5 0B                 LDA   ZINTSHBUF,X              ;Get saved screen hole
0080 8213 91 09                 STA   (ZINT),Y                 ;Restore screen hole byte
0081 8215              @4       EQU   *
0082 8215 E8                    INX                            ;Next location in buffer
0083 8216 A0 80                 LDY   #$80                     ;Offset to next screen hole byte
0084 8218 50 06                 BVC   @5                       ;'v'=0 then restoring screen holes
0085 821A B1 09                 LDA   (ZINT),Y                 ;Get screen hole
0086 821C 95 0B                 STA   ZINTSHBUF,X              ;Save in zero page int scrn hole buffer
0087 821E 80 04                 BRA   @6                       ;
0088 8220
0089 8220              @5       EQU   *
0090 8220 B5 0B                 LDA   ZINTSHBUF,X              ;Get saved screen hole
0091 8222 91 09                 STA   (ZINT),Y                 ;Restore screen hole byte
0092 8224              @6       EQU   *
0093 8224 E8                    INX                            ;Next location in buffer
0094 8225 A5 0A                 LDA   ZINT+1                   ;Increment hi byte of pointer
0095 8227 1A                    INC   A                        ;Increment then test for done
0096 8228 C9 08                 CMP   #$08                     ;If 8 then done
0097 822A 90 D9                 BCC   @2                       ;Loop if < 8
0098 822C
0099 822C A0 7B                 LDY   #$7B                     ;Done if ZINT=$7B
0100 822E C4 09                 CPY   ZINT                     ;= or not
0101 8230 D0 CF                 BNE   @1                       ;Loop til done
0102 8232 60                    RTS                            ;Back to caller
0103 8233
0104 8233
0105 8233
0106 8233
0107 8233                       TITLE 'Control Panel Select Rtnes'
0108 8233
0109 8233              ******************************************************
0110 8233              *                                                    *
0111 8233              *  Select Routines for Control Panel Desk Accessory  *
0112 8233              *                                                    *
0113 8233              *                         by                         *
0114 8233              *               Fern Bachman    $1985-1987           *
0115 8233              *               Joe Bo           1987-1989           *
0116 8233              *                                                    *
0117 8233              *       Copyright Apple Computer, Inc. 1985-1989     *
0118 8233              *                All Rights Reserved.                *
0119 8233              *                                                    *
0120 8233              ******************************************************
0121 8233
0122 8233
0123 8233              * SELECTLINE does all the work necessary to 
0124 8233              * move the user's indicator cursor up and down
0125 8233              * a menu.  It exits when carriage return/escape/
0126 8233              * left or rmght arrow key is pressed indicating
0127 8233              * the user wants to open a feature, ignore changes
0128 8233              * or make a line option change.
0129 8233              *
0130 8233              * Enter SELECTLINE with CURLINE set to option #
0131 8233              * to start indicator on.
0132 8233              *
0133 8233              * Enter SELECTLINE with NUMLINES set to # of
0134 8233              * screen lines+1 available.
0135 8233              *
0136 8233              * In the case of printer or modem screen, it skips over    
0137 8233              * the 1st line whenever it tries to get to that line.    
0138 8233              * To flip to the top or bottom line of the screen has to 
0139 8233              * be taken care.  Also has a special case for AppleTalk
0140 8233              * being selected as the connected device, then the screen
0141 8233              * has a maximum of 5 lines only !!!
0142 8233
0143 8233              SELECTLINE EQU   *                      ;Put up indicator character to start
0144 8233 58                    CLI                            ;Enable clk ints since scrn is set up now
0145 8234 20 44 9A              JSR   PRTMODEM                 ;CHK for 1st line of printer or modem scrn
0146 8237 F0 62                 BEQ   @01                      ;BRA to skip 1st line 
0147 8239 20 B1 82              JSR   @6                       ;Get a keypress for main screen
0148 823C C9 8B                 CMP   #UPAKEY                  ;Up arrow pressed?
0149 823E F0 05                 BEQ   @1                       ;Yes, then do it to it.
0150 8240 C9 8A                 CMP   #DOWNAKEY                ;Down arrow pressed?
0151 8242 F0 3B                 BEQ   @3                       ;Yes, then do it to it.
0152 8244 60                    RTS                            ;Back to caller with CURLINE updated
0153 8245
0154 8245
0155 8245              @1       EQU   *
0156 8245 A5 01                 LDA   CURLINE                  ;Pick up current indicator pstn
0157 8247 D0 04                 BNE   @2                       ;<>0 then just dec and exit
0158 8249 A5 04                 LDA   NUMLINES                 ;# of lines for screen+1
0159 824B 85 01                 STA   CURLINE                  ;Save as new position+1
0160 824D              @2       EQU   *
0161 824D C6 01                 DEC   CURLINE                  ;Decrement position
0162 824F A6 01                 LDX   CURLINE                  ;Valid line or not?
0163 8251 B5 83                 LDA   REALLNTBL,X              ;Test against table entry
0164 8253 30 F0                 BMI   @1                       ;'-' then not a valid position
0165 8255 20 44 9A              JSR   PRTMODEM                 ;CHK for 1st line of printer or modem scrn
0166 8258 D0 16                 BNE   @44                      ;BRA if not
0167 825A A5 01                 LDA   CURLINE                  ;Get current line so that to flip to top
0168 825C D0 41                 BNE   @4                       ; or bottom of the line of the scrn
0169 825E 20 2B 9A              JSR   PRTAPTALK                ;Chk if current screen prt port for Aptalk
0170 8261 F0 09                 BEQ   @24                      ;BRA if yes
0171 8263 20 37 9A              JSR   MODAPTALK                ;CHK if current screen mod port for Aptalk
0172 8266 F0 04                 BEQ   @24                      ;BRA if yes
0173 8268              @23      EQU   *
0174 8268 A9 0B                 LDA   #$0B                     ;Flip to bottom line of the prt/modem scrn
0175 826A 80 31                 BRA   @02                      ; and show new at new position.
0176 826C              @24      EQU   *
0177 826C A9 04                 LDA   #$04                     ;ApTalk maxi has 5 lines only
0178 826E 80 2D                 BRA   @02                      ;BRA to end
0179 8270              @44      EQU   *
0180 8270 20 D5 82              JSR   CHKGSC                   ;Check for GSc and on slot screen
0181 8273 B0 2A                 BCS   @4                       ;BRA if not
0182 8275 A5 01                 LDA   CURLINE                  ; else what line of slot screen
0183 8277 C9 05                 CMP   #$05                     ;
0184 8279 D0 24                 BNE   @4
0185 827B A9 01                 LDA   #$01                     ;
0186 827D 80 1E                 BRA   @02                      ;
0187 827F
0188 827F
0189 827F              @3       EQU   *
0190 827F A5 01                 LDA   CURLINE                  ;Pick up current indicator pstn
0191 8281 1A                    INC   A                        ;Test against number of lines+1 for screen
0192 8282 C5 04                 CMP   NUMLINES                 ;Number of lines for screen+1
0193 8284 90 04                 BCC   @22                      ;<>0 then just dec and exit
0194 8286 A9 FF                 LDA   #$FF                     ;First line for screen-1
0195 8288 85 01                 STA   CURLINE                  ;Save as new position/1
0196 828A              @22      EQU   *
0197 828A E6 01                 INC   CURLINE                  ;Decrement position
0198 828C A6 01                 LDX   CURLINE                  ;Valid line or not?
0199 828E B5 83                 LDA   REALLNTBL,X              ;Test against table entry
0200 8290 30 ED                 BMI   @3                       ;'-' then not a valid position
0201 8292 20 44 9A              JSR   PRTMODEM                 ;CHK for 1st line of printer or modem scrn
0202 8295 D0 0B                 BNE   @46                      ;BRA if not
0203 8297 A5 01                 LDA   CURLINE                  ;Get current line
0204 8299 D0 04                 BNE   @4                       ;BRA if not get to 1st line
0205 829B              @01      EQU   *
0206 829B A9 01                 LDA   #$01                     ; else set to 2nd line
0207 829D              @02      EQU   *
0208 829D 85 01                 STA   CURLINE                  ;Update as new current line
0209 829F              @4       EQU   *                        ;Check if doing main screen or not
0210 829F A9 00                 LDA   #$00                     ;$00 indicates redraw main screen
0211 82A1 60                    RTS                            ;Back to caller
0212 82A2
0213 82A2              @46      EQU   *
0214 82A2 20 D5 82              JSR   CHKGSC
0215 82A5 B0 F8                 BCS   @4
0216 82A7 A5 01                 LDA   CURLINE
0217 82A9 C9 02                 CMP   #$02
0218 82AB D0 F2                 BNE   @4
0219 82AD A9 06                 LDA   #$06                     ;
0220 82AF 80 EC                 BRA   @02                      ;
0221 82B1
0222 82B1
0223 82B1
0224 82B1
0225 82B1              * @6 does the following
0226 82B1              *         1.  Gets a keypress
0227 82B1              *         2.  Tests for arrow keys, carriage return and escape.
0228 82B1              *             If none of these keys it beeps the bell
0229 82B1              *                and looks for another keypress.
0230 82B1              *         3.  Returns 'c'=0 if return/escape/(up/down)
0231 82B1              *                              arrow key pressed
0232 82B1              *                     'c'=1 if left or right arrow was pressed.
0233 82B1              *         4.  Exits with key press in 'A'
0234 82B1
0235 82B1              @6       EQU   *
0236 82B1 20 74 CF              JSR   XRDKBD                   ;Read keys
0237 82B4 10 FB                 BPL   @6                       ;Loop til key pressed
0238 82B6 C9 9B                 CMP   #ESCKEY                  ;ESC key pressed?
0239 82B8 F0 19                 BEQ   @5                       ;= take clear carry exit
0240 82BA C9 8D                 CMP   #RETURNKEY               ;Carriage return ke} pressed?
0241 82BC F0 15                 BEQ   @5                       ;= take carry clear exit
0242 82BE C9 8B                 CMP   #UPAKEY                  ;Up arrow key pressed?
0243 82C0 F0 11                 BEQ   @5                       ;= then take clear carry exit
0244 82C2 C9 8A                 CMP   #DOWNAKEY                ;Down arrow key pressed?
0245 82C4 F0 0D                 BEQ   @5                       ;= then take clear carry exit
0246 82C6 C9 88                 CMP   #LEFTAKEY                ;Left arrow key pressed?
0247 82C8 F0 0A                 BEQ   @52                      ;= then take left/right arrow key exit
0248 82CA C9 95                 CMP   #RIGHTAKEY               ;Right arrow key pressed?
0249 82CC F0 06                 BEQ   @52                      ;= then take left/right arrow key exit
0250 82CE
0251 82CE 20 51 9A     @61      JSR   NEWBELL1                 ;Beep user for bad key press
0252 82D1 80 DE                 BRA   @6                       ;Loop til good key pressed
0253 82D3
0254 82D3              @5       EQU   *                        ;Clear carry exit
0255 82D3 18                    CLC                            ;
0256 82D4              @52      EQU   *                        ;Left/right arrow key exit
0257 82D4 60                    RTS                            ;Back to caller
0258 82D5
0259 82D5
0260 82D5              * Check for GSc and on slot screen: return w/ c=0 then yes
0261 82D5
0262 82D5              CHKGSC   EQU   *
0263 82D5 AF 8E 01 E1           LDA   >KEYUCVER                ;Get keyuc version#
0264 82D9 C9 06                 CMP   #$06                     ;>=$06 then TenSpeed or GSc or newer
0265 82DB 90 0E                 BCC   @4                       ;
0266 82DD AF A5 01 E1           LDA   >GSC                     ;
0267 82E1 10 08                 BPL   @4                       ;BRA if not GSc
0268 82E3 A5 00                 LDA   CURSCRN                  ;What screen ?
0269 82E5 C9 05                 CMP   #CPLN6-CPLN1             ;CHK for slot screen
0270 82E7 D0 02                 BNE   @4                       ;BRA if not 
0271 82E9 18                    CLC                            ;
0272 82EA 60                    RTS   
0273 82EB              @4       EQU   *
0274 82EB 38                    SEC   
0275 82EC 60                    RTS   
0276 82ED
0277 82ED                       TITLE 'Control Panel Tables3'
0278 82ED
0279 82ED              ******************************************************
0280 82ED              *                                                    *
0281 82ED              *      Tables3 for Control Panel Desk Accessory      *
0282 82ED              *                                                    *
0283 82ED              *           Fern Bachman       1985-1987             *
0284 82ED              *           Joe Bo             1987-1989             *
0285 82ED              *                                                    *
0286 82ED              *      Copyright Apple Computer, Inc. 1985-1989      *
0287 82ED              *                All Rights Reserved.                *
0288 82ED              *                                                    *
0289 82ED              ******************************************************
0290 82ED
0291 82ED              * OPTPTRTBL holds pointers to the tables containing
0292 82ED              * the message number for the first option number
0293 82ED              * message of each submenu screen line.
0294 82ED
0295 82ED              OPTPTRTBL EQU   *
0296 82ED 4F                    DC B:DISPOP                    ;Points to line number option msg numbers
0297 82EE 5F                    DC B:SOUNDOP                   ;Points to line number option msg numbers
0298 82EF 6B                    DC B:SYSSPDOP                  ;Points to line number option msg numbers
0299 82F0 69                    DC B:CLOCKOP                   ;Points to line number option msg numbers
0300 82F1 56                    DC B:LANGOP                    ;Points to line number option msg numbers
0301 82F2 61                    DC B:SLOTSOP                   ;Points to line number option msg numbers
0302 82F3 43                    DC B:PORTOP                    ;Points to line number option msg numbers
0303 82F4 43                    DC B:PORTOP                    ;Points to line number option msg numbers
0304 82F5              * DFB >RAMDSKOP ;There are no msg numbers for RAMDSKOP
0305 82F5 00                    DC B:$00                       ;Place holder
0306 82F6 6C                    DC B:MOUSEOP                   ;Points to line number option msg numbers
0307 82F7
0308 82F7
0309 82F7              * NOPTPTRTBL holds pointers to the tables containing
0310 82F7              * the address of the tables containing the number of
0311 82F7              * options for each submenu screen line.
0312 82F7
0313 82F7              NOPTPTRTBL EQU   *
0314 82F7 89                    DC B:NDISPOP                   ;Points to tbl of number of options
0315 82F8 8F                    DC B:NSOUNDOP                  ;Points to tbl of number of options
0316 82F9 91                    DC B:NSYSSPDOP                 ;Points to tbl of number of options
0317 82FA AF                    DC B:NCLOCKOP                  ;Points to tbl of number of options
0318 82FB 9A                    DC B:NLANGOP                   ;Points to tbl of number of options
0319 82FC 92                    DC B:NSLOTSOP                  ;Points to tbl of number of options
0320 82FD 71                    DC B:NPORTOP                   ;Points to tbl of number of options
0321 82FE 71                    DC B:NPORTOP                   ;Points to tbl of number of options
0322 82FF A7                    DC B:NRAMDSKOP                 ;Points to tbl of number of options
0323 8300 AA                    DC B:NMOUSEOP                  ;Points to tbl of number of options
0324 8301
0325 8301
0326 8301              * CPDFPTRTBL holds pointers to the tables containing
0327 8301              * the default option numbers for the first option number
0328 8301              * message of each submenu screen line.
0329 8301
0330 8301              CPDFPTRTBL EQU   *
0331 8301 DD                    DC B:DISPDFT                   ;Points to 1st line number default number
0332 8302 E3                    DC B:SOUNDDFT                  ;Points to 1st line number default number
0333 8303 E5                    DC B:SYSSPDDFT                 ;Points to 1st line number default number
0334 8304 F9                    DC B:CLOCKDFT                  ;Points to 1st line number default number
0335 8305 EE                    DC B:LANGDFT                   ;Points to 1st line number default number
0336 8306 E6                    DC B:SLOTSDFT                  ;Points to 1st line number default number
0337 8307 C5                    DC B:PORT1DFT                  ;Points to 1st line number default number
0338 8308 D1                    DC B:PORT2DFT                  ;Points to 1st line number default number
0339 8309 FB                    DC B:RAMDSKDFT                 ;Points to 1st line number default number
0340 830A FE                    DC B:MOUSEDFT                  ;Points to 1st line number default number
0341 830B
0342 830B
0343 830B              * BRAMPTRTBL holds pointers to the tables containing
0344 830B              * the current option numbers for the first line number
0345 830B              * of each submenu screen.
0346 830B
0347 830B              BRAMPTRTBL EQU   *
0348 830B D8                    DC B:USERCOLOR                 ;Ptr to user value as 1st opt of 1st line
0349 830C DE                    DC B:USERVOL                   ;Ptr to user value as 1st opt of 1st line
0350 830D E0                    DC B:USERSPEED                 ;Ptr to user value as 1st opt of 1st line
0351 830E F4                    DC B:USERDATE                  ;Ptr to user value as 1st opt of 1st line
0352 830F E9                    DC B:USERDISP                  ;Ptr to user value as 1st opt of 1st line
0353 8310 E1                    DC B:USERSLT1                  ;Ptr to user value as 1st opt of 1st line
0354 8311 C0                    DC B:USERPORT1                 ;Ptr to user value as 1st opt of 1st line
0355 8312 CC                    DC B:USERPORT2                 ;Ptr to user value as 1st opt of 1st line
0356 8313 F6                    DC B:USERMRAM                  ;Ptr to user value as 1st opt of 1st line
0357 8314 F9                    DC B:USERHMR                   ;Ptr to user value as 1st opt of 1st line
0358 8315
0359 8315
0360 8315              * TRUELNTBL contains a word for each screen
0361 8315              * which details whether a line is a selectable
0362 8315              * line number or a group delimiter.
0363 8315              * Each bit set is a non accessible line.
0364 8315
0365 8315                                                      ; SEG $FF
0366 8315              TRUELNTBL EQU   *
0367 8315                                                      ; SEG $00
0368 8315 84 FF                 DC W:$FF84                     ;Display lines 7-15,2 not accessible
0369 8317 F2 FF                 DC W:$FFF2                     ;Sound lines 3-15,1 not accessible
0370 8319 FE FF                 DC W:$FFFE                     ;System speed lines 1-15 not accessible
0371 831B 10 FE                 DC W:$FE10                     ;Clock lines 9-15,4 not accessible
0372 831D C0 F8                 DC W:$F8C0                     ;Lang lines 12-15, 6-7 not accessible-"D"
0373 831F 80 FE                 DC W:$FE80                     ;Slots lines 9-15,7 not accessible
0374 8321 00 F0                 DC W:$F000                     ;Port 1 lines 1,12-15 not accessible
0375 8323 00 F0                 DC W:$F000                     ;Port 2 lines 1,12-15 not accessible
0376 8325 FE FE                 DC W:$FEFE                     ;Ramdisk lines 1-7,9-15 not accessible
0377 8327 8C FF                 DC W:$FF8C                     ;Mouse lines 2-3, 7-15 not accessible
0378 8329 FF FF                 DC W:$FFFF                     ;Place holder only
0379 832B 00 F4                 DC W:$F400                     ;Main scrn lines 10, 11-15 not accessible
0380 832D                       EJECT 
0381 832D
0382 832D              * STATTBL is defined as follows
0383 832D              *         Bit 7= 0 normal display functions
0384 832D              *              = 1 special display functions
0385 832D              *         Bit 6= 0 standard change functions
0386 832D              *              = 1 special change functions
0387 832D              *         Bit 5= 0 for no clock box
0388 832D              *              = 1 for clock box
0389 832D              *         Bit 4= 0 for 'Open' box only
0390 832D              *              = 1 for 'Cancel'/'Save' boxes only
0391 832D              *         Bits 3-0 = # of lines/screen+1
0392 832D
0393 832D                                                      ; SEG $FF
0394 832D              STATTBL  EQU   *                        ;Max number of lines/screen+1
0395 832D                                                      ; SEG $00
0396 832D D9                    DC B:$80+$40+$10+DISPLEN       ;SpDisp/Spchange/no clk/Cancel-Save
0397 832E 53                    DC B:$40+$10+SNDLEN            ;NMDisp/Spchange/no clk/Cancel-Save
0398 832F 11                    DC B:$10+SYSSPDLEN             ;NMDisp/NMchange/no clk/Cancel-Save
0399 8330 F9                    DC B:$80+$40+$20+$10+CLKLEN    ;Spdisp/Spchange/clk/Cancel-Save
0400 8331 1B                    DC B:$10+LANGLEN               ;NMDisp/NMchange/no clk/Cancel-Save
0401 8332 19                    DC B:$10+SLOTSLEN              ;NMDisp/NMchange/no clk/Cancel-Save
0402 8333 1C                    DC B:$10+SERIALLEN             ;NMDisp/NMchange/no clk/Cancel-Save
0403 8334 1C                    DC B:$10+SERIALLEN             ;NMDisp/NMchange/no clk/Cancel-Save
0404 8335 D9                    DC B:$80+$40+$10+RAMDSKLEN     ;SpDisp/Spchange/no clk/Cancel-Sve
0405 8336 17                    DC B:$10+MOUSELEN              ;NMDisp/NMchange/no clk/Cancel-save
0406 8337 00                    DC B:$00                       ;Required space holder
0407 8338 2C                    DC B:$20+MMLEN                 ;Normal/TOSEL1/clock/Open
0408 8339
0409 8339
0410 8339              * LNNUMTBL holds the starting message number
0411 8339              * for the first line number message of each
0412 8339              * submenu screen.
0413 8339
0414 8339                                                      ; SEG $FF
0415 8339              LNNUMTBL EQU   *
0416 8339                                                      ; SEG $00
0417 8339 33                    DC B:DISPLN1                   ;1st message number of Display submenu
0418 833A 63                    DC B:SOUNDLN1                  ;1st message number of Sound submenu
0419 833B 3C                    DC B:SYSSPDLN1                 ;1st message number of System Spd submenu
0420 833C 51                    DC B:CLOCKLN1                  ;1st message number of Clock submenu
0421 833D 46                    DC B:LANGLN1                   ;1st message number of Language submenu
0422 833E 3D                    DC B:SLOTSLN1                  ;1st message number of Slots submenu
0423 833F 27                    DC B:SERIALLN1                 ;1st message number of Port 1 submenu
0424 8340 27                    DC B:SERIALLN1                 ;1st message number of Port 2 submenu
0425 8341 5A                    DC B:RAMDSKLN1                 ;1st message number of Ramdisk submenu
0426 8342 66                    DC B:MOUSELN1                  ;1st message number of Mouse submenu
0427 8343
0428 8343
0429 8343
0430 8343
0431 8343              * W A R N I N G: PORTOP through MOUSEDFT must be
0432 8343              *                be on the same page or the tables
0433 8343              *                OPTPTRTBL/NOPTPTRTBL/CPDFPTRTBL
0434 8343              *                will pick up incorrect addresses.
0435 8343                       EJECT 
0436 8343              * PORTOP holds the message number for the first
0437 8343              * option of each line number on the serial ports
0438 8343              * submenu screen.
0439 8343
0440 8343              PORTOP   EQU   *
0441 8343 6D                    DC B:PORTOP1_0                 ;1st message number for line #1
0442 8344 71                    DC B:PORTOP2_0                 ;1st message number for line #2
0443 8345 76                    DC B:PORTOP3_0                 ;1st message number for line #3
0444 8346 76                    DC B:PORTOP4_0                 ;1st message number for line #4
0445 8347 76                    DC B:PORTOP5_0                 ;1st message number for line #5
0446 8348 76                    DC B:PORTOP6_0                 ;1st message number for line #6
0447 8349 78                    DC B:PORTOP7_0                 ;1st message number for line #7
0448 834A 87                    DC B:PORTOP8_0                 ;1st message number for line #8
0449 834B 8F                    DC B:PORTOP9_0                 ;1st message number for line #9
0450 834C 76                    DC B:PORTOP10_0                ;1st message number for line #10
0451 834D 76                    DC B:PORTOP11_0                ;1st message number for line #11
0452 834E 76                    DC B:PORTOP12_0                ;1st message number for line #12
0453 834F
0454 834F
0455 834F              * DISPOP holds the message number for the first
0456 834F              * option of each line number on the display
0457 834F              * submenu screen.
0458 834F
0459 834F              DISPOP   EQU   *
0460 834F 92                    DC B:DISPOP1_0                 ;1st message number for line #1
0461 8350 94                    DC B:DISPOP2_0                 ;1st message number for line #2
0462 8351 96                    DC B:DISPOPC                   ;1st message number for text line
0463 8352 96                    DC B:DISPOPC                   ;1st message number for background line
0464 8353 96                    DC B:DISPOPC                   ;1st message number for border line
0465 8354 76                    DC B:DISPOP3_0                 ;1st message number for line #3
0466 8355 A6                    DC B:DISPOP4_0                 ;1st message number for line #4
0467 8356
0468 8356
0469 8356              * LANGOP holds the message number for the first
0470 8356              * option of each line number on the language
0471 8356              * submenu screen.
0472 8356
0473 8356              LANGOP   EQU   *
0474 8356 A8                    DC B:LANGOP1_0                 ;1st message number for line #1
0475 8357 A8                    DC B:LANGOP2_0                 ;1st message number for line #2
0476 8358 76                    DC B:LANGOP3_0                 ;1st message number for line #3
0477 8359 C8                    DC B:LANGOP4_0                 ;1st message number for line #4
0478 835A D2                    DC B:LANGOP5_0                 ;1st message number for line #5
0479 835B              ;DFB LANGOP6.0 ;1st message number for line #6
0480 835B D2                    DC B:LANGOP7_0                 ;1st message number for line #7
0481 835C 76                    DC B:LANGOP8_0                 ;1st message number for line #8
0482 835D 76                    DC B:LANGOP9_0                 ;1st message number for line #9
0483 835E D7                    DC B:LANGOP10_0                ;1st message number for line #10
0484 835F
0485 835F
0486 835F              * SOUNDOP holds the message number for the first
0487 835F              * option of each line number on the sound
0488 835F              * submenu screen.
0489 835F
0490 835F              SOUNDOP  EQU   *
0491 835F D9                    DC B:SOUNDOP1_0                ;1st message number for line #1
0492 8360 D9                    DC B:SOUNDOP2_0                ;1st message number for line #2
0493 8361
0494 8361
0495 8361              * SLOTSOP holds the message number for the first
0496 8361              * option of each line number on the slots
0497 8361              * submenu screen.
0498 8361
0499 8361              SLOTSOP  EQU   *
0500 8361 00                    DC B:SLOTSOP1_0                ;1st message number for line #1
0501 8362 04                    DC B:SLOTSOP2_0                ;1st message number for line #2
0502 8363 08                    DC B:SLOTSOP3_0                ;1st message number for line #3
0503 8364 0A                    DC B:SLOTSOP4_0                ;1st message number for line #4
0504 8365 0C                    DC B:SLOTSOP5_0                ;1st message number for line #5
0505 8366 0E                    DC B:SLOTSOP6_0                ;1st message number for line #6
0506 8367 10                    DC B:SLOTSOP7_0                ;1st message number for line #7
0507 8368 12                    DC B:SLOTSOP8_0                ;1st message number for line #8
0508 8369
0509 8369
0510 8369              * CLOCKOP holds the message number for the first
0511 8369              * option of each line number on the clock
0512 8369              * submenu screen.
0513 8369
0514 8369              CLOCKOP  EQU   *
0515 8369 E8                    DC B:CLOCKOP1_0                ;1st message number for line #1
0516 836A EB                    DC B:CLOCKOP2_0                ;1st message number for line #2
0517 836B
0518 836B
0519 836B              * SYSSPDOP holds the message number for the first
0520 836B              * option of each line number on the system speed
0521 836B              * submenu screen.
0522 836B
0523 836B              SYSSPDOP EQU   *
0524 836B D7                    DC B:SYSSPDOP1_0               ;1st message number for line #1
0525 836C
0526 836C
0527 836C              * MOUSEOP holds the message number for the first 
0528 836C              * option of each line number on the mouse       
0529 836C              * submenu screen.
0530 836C
0531 836C              MOUSEOP  EQU   *
0532 836C D2                    DC B:MOUSEOP1_0                ;1st message number for line #1
0533 836D D2                    DC B:MOUSEOP2_0                ;1st message number for line #2
0534 836E D2                    DC B:MOUSEOP3_0                ;1st message number for line #3
0535 836F D2                    DC B:MOUSEOP4_0                ;1st message number for line #4
0536 8370 C8                    DC B:MOUSEOP5_0                ;1st message number for line #5
0537 8371
0538 8371
0539 8371
0540 8371
0541 8371              * Start of tables whose order can NEVER be changed
0542 8371
0543 8371                                                      ; SEG $FF
0544 8371              BRAMLIMITS EQU   *                      ;Table of BRAM parameter limits+1
0545 8371                                                      ; SEG $00
0546 8371
0547 8371
0548 8371              * NPORTOP holds the number of options for each
0549 8371              * submenu screen line.
0550 8371
0551 8371              NPORTOP  EQU   *
0552 8371 04                    DC B:NPORTOP1_0                ;Number of options for line #1
0553 8372 05                    DC B:NPORTOP2_0                ;Number of options for line #2
0554 8373 02                    DC B:NPORTOP3_0                ;Number of options for line #3
0555 8374 02                    DC B:NPORTOP4_0                ;Number of options for line #4
0556 8375 02                    DC B:NPORTOP5_0                ;Number of options for line #5
0557 8376 02                    DC B:NPORTOP6_0                ;Number of options for line #6
0558 8377 0F                    DC B:NPORTOP7_0                ;Number of options for line #7
0559 8378 08                    DC B:NPORTOP8_0                ;Number of options for line #8
0560 8379 03                    DC B:NPORTOP9_0                ;Number of options for line #9
0561 837A 02                    DC B:NPORTOP10_0               ;Number of options for line #10
0562 837B 02                    DC B:NPORTOP11_0               ;Number of options for line #11
0563 837C 02                    DC B:NPORTOP12_0               ;Number of options for line #12
0564 837D
0565 837D
0566 837D 04                    DC B:NPORTOP1_0                ;Number of options for line #1
0567 837E 05                    DC B:NPORTOP2_0                ;Number of options for line #2
0568 837F 02                    DC B:NPORTOP3_0                ;Number of options for line #3
0569 8380 02                    DC B:NPORTOP4_0                ;Number of options for line #4
0570 8381 02                    DC B:NPORTOP5_0                ;Number of options for line #5
0571 8382 02                    DC B:NPORTOP6_0                ;Number of options for line #6
0572 8383 0F                    DC B:NPORTOP7_0                ;Number of options for line #7
0573 8384 08                    DC B:NPORTOP8_0                ;Number of options for line #8
0574 8385 03                    DC B:NPORTOP9_0                ;Number of options for line #9
0575 8386 02                    DC B:NPORTOP10_0               ;Number of options for line #10
0576 8387 02                    DC B:NPORTOP11_0               ;Number of options for line #11
0577 8388 02                    DC B:NPORTOP12_0               ;Number of options for line #12
0578 8389
0579 8389
0580 8389              * NDISPOP holds the number of options for each
0581 8389              * submenu screen line.
0582 8389
0583 8389              NDISPOP  EQU   *
0584 8389 02                    DC B:NDISPOP1_0                ;Number of options for line #1
0585 838A 02                    DC B:NDISPOP2_0                ;Number of options for line #2
0586 838B 10                    DC B:NDISPOPC                  ;Number of options for line #3
0587 838C 10                    DC B:NDISPOPC                  ;Number of options for line #4
0588 838D 10                    DC B:NDISPOPC                  ;Number of options for line #5
0589 838E 02                    DC B:NDISPOP4_0                ;Number of options for line #6
0590 838F
0591 838F
0592 838F              * NSOUNDOP holds the number of options for each
0593 838F              * submenu screen line.
0594 838F
0595 838F              NSOUNDOP EQU   *
0596 838F 0F                    DC B:NSOUNDOP1_0               ;Number of options for line #1
0597 8390 0F                    DC B:NSOUNDOP2_0               ;Number of options for line #2
0598 8391
0599 8391
0600 8391              * NSYSSPDOP holds the number of options for each
0601 8391              * submenu screen line.
0602 8391
0603 8391              NSYSSPDOP EQU   *
0604 8391 02                    DC B:NSYSSPDOP1_0              ;Number of options for line #1
0605 8392
0606 8392
0607 8392              * NSLOTSOP holds the number of options for each
0608 8392              * submenu screen line.
0609 8392
0610 8392              NSLOTSOP EQU   *
0611 8392 04                    DC B:NSLOTSOP1_0               ;Number of options for line #1
0612 8393 04                    DC B:NSLOTSOP2_0               ;Number of options for line #2
0613 8394 02                    DC B:NSLOTSOP3_0               ;Number of options for line #3
0614 8395 02                    DC B:NSLOTSOP4_0               ;Number of options for line #4
0615 8396 02                    DC B:NSLOTSOP5_0               ;Number of options for line #5
0616 8397 02                    DC B:NSLOTSOP6_0               ;Number of options for line #6
0617 8398 02                    DC B:NSLOTSOP7_0               ;Number of options for line #7
0618 8399 0B                    DC B:NSLOTSOP8_0               ;Number of options for line #8
0619 839A
0620 839A
0621 839A              * NLANGOP holds the number of options for each
0622 839A              * submenu screen line.
0623 839A
0624 839A              NLANGOP  EQU   *
0625 839A 80                    DC B:$80                       ;Indicate special lookup 1st opt req
0626 839B C0                    DC B:$C0                       ;Indicate special lookup 2nd opt req
0627 839C 02                    DC B:NLANGOP3_0                ;Number of options for line #3
0628 839D 0A                    DC B:NLANGOP4_0                ;Number of options for line #4
0629 839E 05                    DC B:NLANGOP5_0                ;Number of options for line #5
0630 839F              ;DFB NLANGOP6.0 ;Number of options for line #6, gs only
0631 839F 05                    DC B:NLANGOP7_0                ;Number of options for line #7
0632 83A0 02                    DC B:NLANGOP8_0                ;Number of options for line #8
0633 83A1 02                    DC B:NLANGOP9_0                ;Number of options for line #9
0634 83A2 02                    DC B:NLANGOP10_0               ;Number of options for line #10
0635 83A3
0636 83A3              * The disk ejection option keys have the range value not
0637 83A3              * equal or greater than $09, but in ten speed the hardware
0638 83A3              * is not available for the disk ejection keys and the keyuc
0639 83A3              * code had finalized.  Therefore a special index value is
0640 83A3              * used to fool around the keyuc and make the range value to 
0641 83A3              * put here as index($2d) + 1 = $2e
0642 83A3
0643 83A3              ;DFB $09 ;Number of options for line #11
0644 83A3              ;DFB $09 ;Number of options for line #12
0645 83A3 2E                    DC B:$2E                       ;Need to be changed if disk ejection available
0646 83A4 2E                    DC B:$2E                       ;
0647 83A5
0648 83A5
0649 83A5              * NDCLOCKOP is used by the READBR routine to
0650 83A5              * verify that the 2 clock options in BATTERYRAM
0651 83A5              * are within range.
0652 83A5
0653 83A5              *NDCLOCKOP EQU *
0654 83A5 03                    DC B:NCLOCKOP1_0               ;Number of options+1
0655 83A6 02                    DC B:NCLOCKOP2_0               ;Number of options+1
0656 83A7
0657 83A7
0658 83A7              * NRAMDSKOP holds the number of options for each
0659 83A7              * submenu screen line.
0660 83A7
0661 83A7              NRAMDSKOP EQU   *
0662 83A7 80                    DC B:$80                       ;Indicate special lookup
0663 83A8 02                    DC B:NRAMDSKOP8_0              ;Number of options for line #8
0664 83A9 80                    DC B:$80                       ;No longer be able to get to this line
0665 83AA
0666 83AA              * NMOUSEOP holds the number of options for each
0667 83AA              * submenu screen line
0668 83AA
0669 83AA              NMOUSEOP EQU   *
0670 83AA 05                    DC B:NMOUSEOP1_0               ;Number of options for line #1
0671 83AB 05                    DC B:NMOUSEOP2_0               ;Number of options for line #2
0672 83AC 05                    DC B:NMOUSEOP3_0               ;Number of options for line #3
0673 83AD 05                    DC B:NMOUSEOP4_0               ;Number of options for line #4
0674 83AE 0A                    DC B:NMOUSEOP5_0               ;Number of options for line #5
0675 83AF
0676 83AF
0677 83AF              * End of tables whose order can NEVER be changed.
0678 83AF
0679 83AF
0680 83AF
0681 83AF
0682 83AF              * NCLOCKOP holds the number of options for each
0683 83AF              * submenu screen line.
0684 83AF
0685 83AF              NCLOCKOP EQU   *
0686 83AF 0C                    DC B:12                        ;Max month+1=12
0687 83B0 1F                    DC B:31                        ;Max day+1=31
0688 83B1 64                    DC B:100                       ;Max year+1=100
0689 83B2 03                    DC B:03                        ;Max date format+1=3
0690 83B3 18                    DC B:24                        ;Max hour+1=24
0691 83B4 3C                    DC B:60                        ;Max minute+1=60
0692 83B5 3C                    DC B:60                        ;Max second+1=60
0693 83B6 02                    DC B:02                        ;Max time format+1=2
0694 83B7
0695 83B7
0696 83B7              * MONTHLEN holds the number of days for each
0697 83B7              * month.
0698 83B7
0699 83B7                                                      ; SEG $FF
0700 83B7              MONTHLEN EQU   *
0701 83B7                                                      ; SEG $00
0702 83B7 1F                    DC B:31                        ;Days in January
0703 83B8 1C                    DC B:28                        ;Days in non leap year February
0704 83B9 1F                    DC B:31                        ;Days in March
0705 83BA 1E                    DC B:30                        ;Days in April
0706 83BB 1F                    DC B:31                        ;Days in May
0707 83BC 1E                    DC B:30                        ;Days in June
0708 83BD 1F                    DC B:31                        ;Days in July
0709 83BE 1F                    DC B:31                        ;Days in August
0710 83BF 1E                    DC B:30                        ;Days in September
0711 83C0 1F                    DC B:31                        ;Days in October
0712 83C1 1E                    DC B:30                        ;Days in November
0713 83C2 1F                    DC B:31                        ;Days in December
0714 83C3 1D                    DC B:29                        ;Days in leap year February
0715 83C4
0716 83C4              NSPCLSLT1 EQU   *
0717 83C4 04                    DC B:$04                       ;Max allowable new slot1 #, <=$03
0718 83C5
0719 83C5
0720 83C5
0721 83C5
0722 83C5                       TITLE 'BATTERYRAM Default Values'
0723 83C5
0724 83C5              ******************************************************
0725 83C5              *                                                    *
0726 83C5              *  BATTERYRAM Default Values for Ctrl Panel Dsk Acc  *
0727 83C5              *                                                    *
0728 83C5              *                    by                         *
0729 83C5              *               Fern Bachman     1985-1987           *
0730 83C5              *               Joe Bo           1987-1989           *
0731 83C5              *                                                    *
0732 83C5              *       Copyright Apple Computer, Inc. 1985-1989     *
0733 83C5              *                All Rights Reserved.                *
0734 83C5              *                                                    *
0735 83C5              ******************************************************
0736 83C5
0737 83C5
0738 83C5                                                      ; SEG $FF
0739 83C5              CPDEFTBL EQU   *                        ;Control Panel Defaults table
0740 83C5
0741 83C5              * Port 1 selections
0742 83C5
0743 83C5              PORT1DFT EQU   *
0744 83C5 00                    DC B:$00                       ;Device Connected: Printer
0745 83C6 00                    DC B:$00                       ;Line Length: Unlimited
0746 83C7 00                    DC B:$00                       ;Delete First LF after CR: No
0747 83C8 01                    DC B:$01                       ;Add LF after CR: Yes
0748 83C9 00                    DC B:$00                       ;Echo: No
0749 83CA 00                    DC B:$00                       ;Buffering: No
0750 83CB 0D                    DC B:$0D                       ;Baud: 9600
0751 83CC 06                    DC B:$06                       ;Data/Stop Bits: 8/1
0752 83CD 02                    DC B:$02                       ;Parity: None
0753 83CE 01                    DC B:$01                       ;DCD Handshake: Yes
0754 83CF 01                    DC B:$01                       ;DSR Handshake: Yes
0755 83D0 00                    DC B:$00                       ;XON/XOFF Handshake: No
0756 83D1
0757 83D1              * Port 2 selections
0758 83D1
0759 83D1              PORT2DFT EQU   *
0760 83D1 01                    DC B:$01                       ;Device Connected: Modem
0761 83D2 00                    DC B:$00                       ;Line Length: Unlimited
0762 83D3 00                    DC B:$00                       ;Delete First LF after CR: No
0763 83D4 00                    DC B:$00                       ;Add LF after CR: No
0764 83D5 00                    DC B:$00                       ;Echo: No
0765 83D6 00                    DC B:$00                       ;Buffering: No
0766 83D7 07                    DC B:$07                       ;Baud: 1200
0767 83D8 06                    DC B:$06                       ;Data/Stop Bits: 8/1
0768 83D9 02                    DC B:$02                       ;Parity: None
0769 83DA 01                    DC B:$01                       ;DCD Handshake: Yes
0770 83DB 01                    DC B:$01                       ;DSR Handshake: Yes
0771 83DC 00                    DC B:$00                       ;XON/XOFF Handshake: No
0772 83DD
0773 83DD              * Display selections
0774 83DD
0775 83DD              DISPDFT  EQU   *
0776 83DD 00                    DC B:$00                       ;Type: Color
0777 83DE 00                    DC B:$00                       ;Columns: 40
0778 83DF 0F           DISPDFTT DC B:$0F                       ;Text: (White)
0779 83E0 06           DISPDFTBK DC B:$06                      ;Background: (Medium Blue)
0780 83E1 06           DISPDFTBD DC B:$06                      ;Border: (Medium Blue)
0781 83E2 00                    DC B:$00                       ;Hertz: 60
0782 83E3
0783 83E3              * Sound selections
0784 83E3
0785 83E3              SOUNDDFT EQU   *
0786 83E3 05                    DC B:$05                       ;Volume: |-----*---------|
0787 83E4 06                    DC B:$06                       ; Pitch: |------*--------|
0788 83E5
0789 83E5              * Speed selections
0790 83E5
0791 83E5              SYSSPDDFT EQU   *
0792 83E5 01                    DC B:$01                       ;Speed: Fast
0793 83E6
0794 83E6              * Slots' selections
0795 83E6
0796 83E6              SLOTSDFT EQU   *
0797 83E6 00                    DC B:$00                       ;Slot 1: Port 1
0798 83E7 00                    DC B:$00                       ;Slot 2: Port 2
0799 83E8 00                    DC B:$00                       ;Slot 3: Text Display
0800 83E9 00                    DC B:$00                       ;Slot 4: Mouse     
0801 83EA 00                    DC B:$00                       ;Slot 5: Smart Port
0802 83EB 00                    DC B:$00                       ;Slot 6: Disk Port
0803 83EC 01                    DC B:$01                       ;Slot 7: Your Card
0804 83ED 00                    DC B:$00                       ;Startup Slot: Scan
0805 83EE
0806 83EE              * Language selections
0807 83EE
0808 83EE              LANGDFT  EQU   *
0809 83EE 00                    DC B:$00                       ;Text Display: English (U.S.)
0810 83EF 00                    DC B:$00                       ;Keyboard: English (U.S.)
0811 83F0 00                    DC B:$00                       ;Keyboard Buffering: No
0812 83F1 05                    DC B:$05                       ;Repeat Speed: |------*--------|
0813 83F2 02                    DC B:$02                       ;Repeat Delay: |-----*---------|
0814 83F3              ;DFB $02 ;Double Click: |-----*---------|, move out !!   
0815 83F3 02                    DC B:$02                       ;Cursor Flash: |-----*---------|
0816 83F4 00                    DC B:$00                       ;Shift Caps/Lower Case: No
0817 83F5 00                    DC B:$00                       ;Fast Space/Delete Keys: No
0818 83F6 00                    DC B:$00                       ;Dual Speed Keys: Normal
0819 83F7              *
0820 83F7              * Disk ejection keys not implemented yet, set this special index
0821 83F7              * to fool around keyuc not to wipe out any combination keys of
0822 83F7              * apple-shift-XXX.
0823 83F7              *
0824 83F7 2D                    DC B:$2D                       ;Disk1 ejection, 0 -> 1, 1->2, ......
0825 83F8 2D                    DC B:$2D                       ;Disk2 ejection, 1 -> 2, 2->3, ......
0826 83F9
0827 83F9              * Clock selections
0828 83F9
0829 83F9              CLOCKDFT EQU   *
0830 83F9 00                    DC B:$00                       ;Format: MM/DD/YY
0831 83FA 00                    DC B:$00                       ;Format: AM-PM
0832 83FB
0833 83FB              * Ramdisk selections
0834 83FB
0835 83FB              RAMDSKDFT EQU   *
0836 83FB 00                    DC B:$00                       ;Minimum RAM for Ramdisk option number
0837 83FC 00                    DC B:$00                       ;Maximum RAM for Ramdisk option number
0838 83FD 00                    DC B:$00                       ;Reset RAMdisk during next reset
0839 83FE
0840 83FE              * Mouse defaults
0841 83FE
0842 83FE              MOUSEDFT EQU   *
0843 83FE 00                    DC B:$00                       ;Mouse Tracking: |*--------------|
0844 83FF 02                    DC B:$02                       ;Double Click:   |-----*---------|
0845 8400 02                    DC B:$02                       ;Start Delay:    |-----*---------|
0846 8401 02                    DC B:$02                       ;Acceleration:   |-----*---------|
0847 8402 06                    DC B:$06                       ;Maximum Speed:  |-----*---------|
0848 8403
0849 8403
0850 8403 08                    DC B:8                         ;Number of languages from keyboard micro
0851 8404 00                    DC B:0                         ;Option number of language
0852 8405 01                    DC B:1                         ;Option number of language
0853 8406 02                    DC B:2                         ;Option number of language
0854 8407 03                    DC B:3                         ;Option number of language
0855 8408 04                    DC B:4                         ;Option number of language
0856 8409 05                    DC B:5                         ;Option number of language
0857 840A 06                    DC B:6                         ;Option number of language
0858 840B 07                    DC B:7                         ;Option number of language
0859 840C
0860 840C 0A                    DC B:10                        ;Number of layouts from keyboard micro
0861 840D 00                    DC B:0                         ;Option number of layout
0862 840E 01                    DC B:1                         ;Option number of layout
0863 840F 02                    DC B:2                         ;Option number of layout
0864 8410 03                    DC B:3                         ;Option number of layout
0865 8411 04                    DC B:4                         ;Option number of layout
0866 8412 05                    DC B:5                         ;Option number of layout
0867 8413 06                    DC B:6                         ;Option number of layout
0868 8414 07                    DC B:7                         ;Option number of layout
0869 8415 08                    DC B:8                         ;Option number of layout
0870 8416 09                    DC B:9                         ;Option number of layout
0871 8417 0A                    DC B:10                        ;Option number of layout
0872 8418 0B                    DC B:11                        ;Option number of layout
0873 8419 0C                    DC B:12                        ;Option number of layout
0874 841A 0D                    DC B:13                        ;Option number of layout
0875 841B 0E                    DC B:14                        ;Option number of layout
0876 841C 0F                    DC B:15                        ;Option number of layout
0877 841D
0878 841D              * This byte is newly picked for slot1 configuration, it is       
0879 841D              * different from the USERSLT1 that this byte will actually 
0880 841D              * contain the right value (0,1,2,3) for the selection of 
0881 841D              * slot1 where as USERSLT1 will only contain (0,1) for   
0882 841D              * internal/external selection of the card.  Doing this way
0883 841D              * so AppleTalk firmware can survive in either of the system
0884 841D              * disk (must be >= 3.2).
0885 841D
0886 841D 00           NEWSLT1  DC B:$00                       ;Set new slot1 default to printer
0887 841E 00           ROMDADEF DC B:$00                       ;$00 not install monitor/memory peeker
0888 841F
0889 841F
0890 841F              SAMEPAGE1 PgAdrEQU PORTOP
0891 841F              SAMEPAGE2 PgAdrEQU MOUSEDFT
0892 841F                       IF (SAMEPAGE1-SAMEPAGE2) THEN 
0893 841F                       WRITELN '### ERROR: PORTOP -> MOUSEDFT MUST be in the same page!'
0894 841F                       ENDIF 
0895 841F
0896 841F              CPDTBLLN EQU   *-CPDEFTBL
0897 841F
0898 841F                       EJECT 
0899 841F
0900 841F                       TITLE 'Control Panel Tables2'
0901 841F
0902 841F              ******************************************************
0903 841F              *                                                    *
0904 841F              *     Tables2 for Control Panel Desk Accessory       *
0905 841F              *                                                    *
0906 841F              *                    by                              *
0907 841F              *               Fern Bachman     1985-1987           *
0908 841F              *               Joe Bo           1987-1989           *
0909 841F              *                                                    *
0910 841F              *      Copyright Apple Computer, Inc. 1985-1989      *
0911 841F              *                All Rights Reserved.                *
0912 841F              *                                                    *
0913 841F              ******************************************************
0914 841F
0915 841F
0916 841F A0 A0 A0 CD           DC B:'   March 17, 1987'       ;DATE
0917 8430
0918 8430
0919 8430              * Miscellaneous messages
0920 8430              *
0921 8430              * WARNING: The 'DW's below MUST be in the same
0922 8430              *          order as the previous CP.TABLES or the print
0923 8430              *          program will display the wrong messages.
0924 8430
0925 8430
0926 8430                                                      ; SEG $FF
0927 8430              MSGTBL   EQU   *
0928 8430                                                      ; SEG $00
0929 8430 B7 86                 DC W:BOOTMSGA                  ;'I/O error!' message address
0930 8432 C5 86                 DC W:DISKMSGA                  ;'Not a bootable disk!' message address
0931 8434 DC 86                 DC W:DEVMSGA                   ;'No device connected!' message address
0932 8436 F4 86                 DC W:CHKDEVMSGA                ;'Check startup device!' message address
0933 8438 6A 86                 DC W:TIMEMSGA                  ;'Time=' message address
0934 843A 70 86                 DC W:STEPMSGA                  ;'Step' message address
0935 843C 74 86                 DC W:TRACEMSGA                 ;'Trace' message address
0936 843E 79 86                 DC W:CBANKMSGA                 ;'Cbank' message address
0937 8440 84 86                 DC W:DECMSGA                   ;'Decimal' message address
0938 8442 8E 86                 DC W:HEXMSGA                   ;'Hex' message address
0939 8444 91 86                 DC W:ARWDASHDOLA               ;'-> $' message address
0940 8446 95 86                 DC W:TLERRMSGA                 ;'Tool error= ' message address
0941 8448 0D 87                 DC W:SYSDMSGA                  ;'Fatal system error-> ' message address
0942 844A
0943 844A              * Special entry to Control Panel ASCII
0944 844A
0945 844A 25 88                 DC W:SPCHOICESA                ;Special entry control panel ASCII
0946 844C
0947 844C              * Desk Accessory Title
0948 844C
0949 844C A2 86                 DC W:CPTITLEA                  ;' Control Panel' message address 
0950 844E
0951 844E              * Prompts / Footnotes
0952 844E
0953 844E B0 86                 DC W:TOSELUSEA                 ;'Select:' message address 
0954 8450 2E 87                 DC W:UDSELA                    ;' ^ v' message address 
0955 8452 33 87                 DC W:LRSELA                    ;' < >' message address 
0956 8454 39 87                 DC W:OPENCRA                   ;'Open CR' message address
0957 8456 43 87                 DC W:SAVECRA                   ;'Save CR' message address
0958 8458 4D 87                 DC W:CANCELESCA                ;'Cancel ESC' message address
0959 845A 59 87                 DC W:SPACEBOXA                 ;'|              |' message address
0960 845C 24 87                 DC W:TOPBOXA                   ;' ______________ ' message address
0961 845E 29 87                 DC W:BOTTOMBOXA                ;' -------------- ' message address
0962 8460 6E 87                 DC W:APS1S2L1A                 ;'ApTalk/Ser Prt1/Ser Prt2 part 1 msg addr
0963 8462 95 87                 DC W:APS1S2L2A                 ;'ApTalk/Ser Prt1/Ser Prt2 part 2 msg addr
0964 8464 BC 87                 DC W:TWOAPTALKA                ;'AppleTalk already Selected' msg addr
0965 8466
0966 8466              * Main Menu
0967 8466
0968 8466 4A 89                 DC W:CPLN1A                    ;'Display' message address 
0969 8468 51 89                 DC W:CPLN2A                    ;'Sound' message address 
0970 846A 56 89                 DC W:CPLN3A                    ;'System Speed' message address 
0971 846C 62 89                 DC W:CPLN4A                    ;'Clock' message address 
0972 846E 67 89                 DC W:CPLN5A                    ;'Language' message address 
0973 8470 6F 89                 DC W:CPLN6A                    ;'Slots' message address 
0974 8472 74 89                 DC W:CPLN7A                    ;'Port 1' message address 
0975 8474 80 89                 DC W:CPLN8A                    ;'Port 2' message address 
0976 8476 8A 89                 DC W:CPLN9A                    ;'Ramdisk' message address 
0977 8478 96 89                 DC W:CPLN11A                   ;'Mouse' message address
0978 847A 0B 8C                 DC W:SPACEA                    ;'  ' message address
0979 847C 92 89                 DC W:CPLN10A                   ;'Quit' message address 
0980 847E
0981 847E              * Serial Port
0982 847E
0983 847E 9B 89                 DC W:SERIALLN1A                ;'Device Connected' message address 
0984 8480 AC 89                 DC W:SERIALLN2A                ;'Line Length' message address 
0985 8482 B7 89                 DC W:SERIALLN3A                ;'Delete First LF after CR' message addr
0986 8484 CF 89                 DC W:SERIALLN4A                ;'Add LF after CR' message address 
0987 8486 DE 89                 DC W:SERIALLN5A                ;'Echo' message address 
0988 8488 E2 89                 DC W:SERIALLN6A                ;'Buffering' message address 
0989 848A EB 89                 DC W:SERIALLN7A                ;'Baud' message address 
0990 848C EF 89                 DC W:SERIALLN8A                ;'Data/Stop Bits' message address 
0991 848E FD 89                 DC W:SERIALLN9A                ;'Parity' message address 
0992 8490 03 8A                 DC W:SERIALLN10A               ;'DCD Handshake' message address
0993 8492 10 8A                 DC W:SERIALLN11A               ;'DSR Handshake' message address
0994 8494 21 8A                 DC W:SERIALLN12A               ;'XON/XOFF Handshake' message address
0995 8496
0996 8496              * Display
0997 8496
0998 8496 33 8A                 DC W:DISPLN1A                  ;'Type' message address 
0999 8498 37 8A                 DC W:DISPLN2A                  ;'Columns' message address 
1000 849A 5E 87                 DC W:COLORSA                   ;'-Screen Colors-' message address
1001 849C 3E 8A                 DC W:DISPLN3A                  ;'Text' message address 
1002 849E 42 8A                 DC W:DISPLN4A                  ;'Background' message address 
1003 84A0 4C 8A                 DC W:DISPLN5A                  ;'Border' message address 
1004 84A2 52 8A                 DC W:DISPLN6A                  ;'Standards' message address
1005 84A4 0B 8C                 DC W:SPACEA                    ;'  ' message address
1006 84A6 04 88                 DC W:DISPLN7A                  ;'Hertz' message address
1007 84A8
1008 84A8              * System Speed
1009 84A8
1010 84A8 56 89                 DC W:CPLN3A                    ;'System Speed' message address 
1011 84AA
1012 84AA              * Slots
1013 84AA
1014 84AA D8 8A                 DC W:SLOTSLN1A                 ;'Slot 1' message address 
1015 84AC DF 8A                 DC W:SLOTSLN2A                 ;'Slot 2' message address 
1016 84AE E6 8A                 DC W:SLOTSLN3A                 ;'Slot 3' message address 
1017 84B0 ED 8A                 DC W:SLOTSLN4A                 ;'Slot 4' message address 
1018 84B2 F4 8A                 DC W:SLOTSLN5A                 ;'Slot 5' message address 
1019 84B4 FB 8A                 DC W:SLOTSLN6A                 ;'Slot 6' message address 
1020 84B6 02 8B                 DC W:SLOTSLN7A                 ;'Slot 7' message address 
1021 84B8 0B 8C                 DC W:SPACEA                    ;'  ' message address
1022 84BA 09 8B                 DC W:SLOTSLN8A                 ;'Startup Slot' message address 
1023 84BC
1024 84BC              * Options
1025 84BC
1026 84BC 10 8B                 DC W:LANGLN1A                  ;'Language' message address 
1027 84BE 20 8B                 DC W:LANGLN2A                  ;'Keyboard' message address 
1028 84C0 2F 8B                 DC W:LANGLN3A                  ;'Keyboard Buffering' message address
1029 84C2 41 8B                 DC W:LANGLN4A                  ;'Repeat Speed' message address 
1030 84C4 4D 8B                 DC W:LANGLN5A                  ;'Delay to Repeat' message address 
1031 84C6 59 8B                 DC W:LANGLN7A                  ;'Flash Rate of Cursor' message address 
1032 84C8 0B 8C                 DC W:SPACEA                    ;'   ' Message address
1033 84CA E3 87                 DC W:ADVANCEDA                 ;'-Advanced Features-' message address 
1034 84CC 65 8B                 DC W:LANGLN8A                  ;'Shift Caps/Lower Case' message address 
1035 84CE 79 8B                 DC W:LANGLN9A                  ;'Fast Space/Delete Keys' msg address 
1036 84D0 8F 8B                 DC W:LANGLN10A                 ;'Dual Speed' message address 
1037 84D2
1038 84D2              * Clock
1039 84D2
1040 84D2 9E 8B                 DC W:CLOCKLN1A                 ;'Month' message address 
1041 84D4 A3 8B                 DC W:CLOCKLN2A                 ;'Day' message address 
1042 84D6 A6 8B                 DC W:CLOCKLN3A                 ;'Year' message address 
1043 84D8 AA 8B                 DC W:CLOCKLN4A                 ;'Format' message address 
1044 84DA 0B 8C                 DC W:SPACEA                    ;'  ' message address
1045 84DC B0 8B                 DC W:CLOCKLN6A                 ;'Hour' message address 
1046 84DE B4 8B                 DC W:CLOCKLN7A                 ;'Minute' message address 
1047 84E0 BA 8B                 DC W:CLOCKLN8A                 ;'Second' message address 
1048 84E2 AA 8B                 DC W:CLOCKLN4A                 ;'Format' message address 
1049 84E4
1050 84E4
1051 84E4              * Ramdisk
1052 84E4
1053 84E4 C0 8B                 DC W:RAMDSKLN1A                ;'Select Ramdisk Size' message address
1054 84E6              ;DW RAMDSKLN2A ;'Maximum Ramdisk Size' message address
1055 84E6 0D 88                 DC W:RAMDSKLN3A                ;'-Largest Selectable Size' message addr
1056 84E8 0B 8C                 DC W:SPACEA                    ;'  ' message address
1057 84EA F7 87                 DC W:STATUSA                   ;'-RAM Status-' message address
1058 84EC D6 8B                 DC W:RAMDSKLN4A                ;'RAM disk Size' message address
1059 84EE E7 8B                 DC W:RAMDSKLN5A                ;'Total RAM in Use' message address
1060 84F0 FB 8B                 DC W:RAMDSKLN6A                ;'Total Free RAM' message address
1061 84F2 0B 8C                 DC W:SPACEA                    ;' ' message address
1062 84F4 0D 8C                 DC W:RAMDSKLN7A                ;'Re-size during next reset' message #
1063 84F6
1064 84F6
1065 84F6              * Sound
1066 84F6
1067 84F6 1F 8C                 DC W:SOUNDLN1A                 ;'Volume' message address
1068 84F8 0B 8C                 DC W:SPACEA                    ;'  ' message address
1069 84FA 25 8C                 DC W:SOUNDLN2A                 ;' Pitch' message address
1070 84FC
1071 84FC              * Mouse
1072 84FC
1073 84FC 2B 8C                 DC W:MOUSELN1A                 ;'Mouse Tracking' message address
1074 84FE 39 8C                 DC W:MOUSELN2A                 ;'Double click' message address
1075 8500 0B 8C                 DC W:SPACEA                    ;'   ' message address
1076 8502 71 8C                 DC W:ADVMSEMSGA                ;'-Keyboard Mouse-' msg address
1077 8504 47 8C                 DC W:MOUSELN3A                 ;'Start Delay' message address
1078 8506 55 8C                 DC W:MOUSELN4A                 ;'Acceleration' message address
1079 8508 63 8C                 DC W:MOUSELN5A                 ;'Maxm Speed ' message address
1080 850A
1081 850A                       EJECT 
1082 850A
1083 850A              * Serial Port Options
1084 850A
1085 850A 81 8C                 DC W:PORTOP1_0A                ;'Printer' message address
1086 850C 89 8C                 DC W:PORTOP1_1A                ;'Modem' message address
1087 850E 8F 8C                 DC W:PORTOP1_2A                ;'AppleTalk' message number
1088 8510 99 8C                 DC W:PORTOP1_3A                ;'Your Card' message address
1089 8512
1090 8512 A3 8C                 DC W:PORTOP2_0A                ;'40' message address
1091 8514 AC 8C                 DC W:PORTOP2_1A                ;'72' message address
1092 8516 AE 8C                 DC W:PORTOP2_2A                ;'80' message address
1093 8518 B0 8C                 DC W:PORTOP2_3A                ;'132' message address
1094 851A B2 8C                 DC W:PORTOP2_4A                ;'Unlimited' message address
1095 851C
1096 851C B5 8C                 DC W:PORTOP3_0A                ;'No' message address
1097 851E B7 8C                 DC W:PORTOP3_1A                ;'Yes' message address
1098 8520
1099 8520 BA 8C                 DC W:PORTOP7_0A                ;'50' message address
1100 8522 BC 8C                 DC W:PORTOP7_1A                ;'75' message address
1101 8524 BE 8C                 DC W:PORTOP7_2A                ;'110' message address
1102 8526 C1 8C                 DC W:PORTOP7_3A                ;'134.5' message address
1103 8528 C6 8C                 DC W:PORTOP7_4A                ;'150' message address
1104 852A C9 8C                 DC W:PORTOP7_5A                ;'300' message address
1105 852C CC 8C                 DC W:PORTOP7_6A                ;'600' message address
1106 852E CF 8C                 DC W:PORTOP7_7A                ;'1200' message address
1107 8530 D3 8C                 DC W:PORTOP7_8A                ;'1800' message address
1108 8532 D7 8C                 DC W:PORTOP7_9A                ;'2400' message address
1109 8534 DB 8C                 DC W:PORTOP7_10A               ;'3600' message address
1110 8536 DF 8C                 DC W:PORTOP7_11A               ;'4800' message address
1111 8538 E3 8C                 DC W:PORTOP7_12A               ;'7200' message address
1112 853A E7 8C                 DC W:PORTOP7_13A               ;'9600' message address
1113 853C EB 8C                 DC W:PORTOP7_14A               ;'19200' message address
1114 853E
1115 853E F0 8C                 DC W:PORTOP8_0A                ;'5/1' message address
1116 8540 F3 8C                 DC W:PORTOP8_1A                ;'5/2' message address
1117 8542 F6 8C                 DC W:PORTOP8_2A                ;'6/1' message address
1118 8544 F9 8C                 DC W:PORTOP8_3A                ;'6/2' message address
1119 8546 FC 8C                 DC W:PORTOP8_4A                ;'7/1' message address
1120 8548 FF 8C                 DC W:PORTOP8_5A                ;'7/2' message address
1121 854A 02 8D                 DC W:PORTOP8_6A                ;'8/1' message address
1122 854C 05 8D                 DC W:PORTOP8_7A                ;'8/2' message address
1123 854E
1124 854E 08 8D                 DC W:PORTOP9_0A                ;'Odd' message address
1125 8550 0B 8D                 DC W:PORTOP9_1A                ;'Even' message address
1126 8552 0F 8D                 DC W:PORTOP9_2A                ;'None' message address
1127 8554
1128 8554
1129 8554              * Display Options
1130 8554
1131 8554 13 8D                 DC W:DISPOP1_0A                ;'Color' message address
1132 8556 18 8D                 DC W:DISPOP1_1A                ;'Monochrome' message address
1133 8558
1134 8558 AC 8C                 DC W:PORTOP2_1A                ;'40' message address
1135 855A B0 8C                 DC W:PORTOP2_3A                ;'80' message number
1136 855C
1137 855C 5B 8A                 DC W:DISPOPC0A                 ;'Black' color message address
1138 855E 60 8A                 DC W:DISPOPC1A                 ;'Deep Red' color message address
1139 8560 68 8A                 DC W:DISPOPC2A                 ;'Dark Blue' color message address
1140 8562 71 8A                 DC W:DISPOPC3A                 ;'Purple' color message address
1141 8564 77 8A                 DC W:DISPOPC4A                 ;'Dark Green' color message address
1142 8566 81 8A                 DC W:DISPOPC5A                 ;'Dark Gray' color message address
1143 8568 8A 8A                 DC W:DISPOPC6A                 ;'Medium Blue' color message address
1144 856A 95 8A                 DC W:DISPOPC7A                 ;'Light Blue' color message address
1145 856C 9F 8A                 DC W:DISPOPC8A                 ;'Brown' color message address
1146 856E A4 8A                 DC W:DISPOPC9A                 ;'Orange' color message address
1147 8570 AA 8A                 DC W:DISPOPC10A                ;'Light Gray' color message address
1148 8572 B4 8A                 DC W:DISPOPC11A                ;'Pink' color message address
1149 8574 B8 8A                 DC W:DISPOPC12A                ;'Light Green' color message address
1150 8576 C3 8A                 DC W:DISPOPC13A                ;'Yellow' color message address
1151 8578 C9 8A                 DC W:DISPOPC14A                ;'Aquamarine' color message address
1152 857A D3 8A                 DC W:DISPOPC15A                ;'White' color message address
1153 857C
1154 857C 22 8D                 DC W:DISPOP3_0A                ;'60' message number
1155 857E BA 8C                 DC W:PORTOP7_0A                ;'50' message number
1156 8580
1157 8580
1158 8580              * Language Options
1159 8580
1160 8580 24 8D                 DC W:LANGOP1_0A                ;'U.S.A' message address
1161 8582 2A 8D                 DC W:LANGOP1_1A                ;'U.K.' message address
1162 8584 2E 8D                 DC W:LANGOP1_2A                ;'French' message address
1163 8586 34 8D                 DC W:LANGOP1_3A                ;'Danish' message address
1164 8588 3A 8D                 DC W:LANGOP1_4A                ;'Spanish' message address
1165 858A 41 8D                 DC W:LANGOP1_5A                ;'Italian' message address
1166 858C 48 8D                 DC W:LANGOP1_6A                ;'German' message address
1167 858E 4E 8D                 DC W:LANGOP1_7A                ;'Swedish' message address
1168 8590 55 8D                 DC W:LANGOP1_8A                ;'Dvorak' message address
1169 8592 5B 8D                 DC W:LANGOP1_9A                ;'French Canadian' message address
1170 8594 6A 8D                 DC W:LANGOP1_10A               ;'Flemish' message address
1171 8596 71 8D                 DC W:LANGOP1_11A               ;'Hebrew' message address
1172 8598 77 8D                 DC W:LANGOP1_12A               ;'Japanese' message address
1173 859A 7F 8D                 DC W:LANGOP1_13A               ;'Arabic' message address
1174 859C 85 8D                 DC W:LANGOP1_14A               ;'Greek' message address
1175 859E 8A 8D                 DC W:LANGOP1_15A               ;'Turkish' message address
1176 85A0 91 8D                 DC W:LANGOP1_16A               ;'Finnish' message address
1177 85A2 98 8D                 DC W:LANGOP1_17A               ;'Portuguese' message address
1178 85A4 A2 8D                 DC W:LANGOP1_18A               ;'Tamil' message address
1179 85A6 A7 8D                 DC W:LANGOP1_19A               ;'Hindu' message address
1180 85A8 AC 8D                 DC W:LANGOP1_20A               ;'T1' message address
1181 85AA AE 8D                 DC W:LANGOP1_21A               ;'T2' message address
1182 85AC B0 8D                 DC W:LANGOP1_22A               ;'T3' message address
1183 85AE B2 8D                 DC W:LANGOP1_23A               ;'T4' message address
1184 85B0 B4 8D                 DC W:LANGOP1_24A               ;'T5' message address
1185 85B2 B6 8D                 DC W:LANGOP1_25A               ;'T6' message address
1186 85B4 B8 8D                 DC W:LANGOP1_26A               ;'L1' message address
1187 85B6 BA 8D                 DC W:LANGOP1_27A               ;'L2' message address
1188 85B8 BC 8D                 DC W:LANGOP1_28A               ;'L3' message address
1189 85BA BE 8D                 DC W:LANGOP1_29A               ;'L4' message address
1190 85BC C0 8D                 DC W:LANGOP1_30A               ;'L5' message address
1191 85BE C2 8D                 DC W:LANGOP1_31A               ;'L6' message address
1192 85C0
1193 85C0 D7 88                 DC W:BAR0A                     ;'|*--------------|' message address
1194 85C2 DD 88                 DC W:BAR1A                     ;'|-*-------------|' message address
1195 85C4 E4 88                 DC W:BAR2A                     ;'|--*------------|' message address
1196 85C6 EC 88                 DC W:BAR3A                     ;'|---*-----------|' message address
1197 85C8 F4 88                 DC W:BAR4A                     ;'|----*----------|' message address
1198 85CA 04 89                 DC W:BAR6A                     ;'|------*--------|' message address
1199 85CC 14 89                 DC W:BAR8A                     ;'|--------*------|' message address
1200 85CE 24 89                 DC W:BAR10A                    ;'|----------*----|' message address
1201 85D0 34 89                 DC W:BAR12A                    ;'|------------*--|' message address
1202 85D2 43 89                 DC W:BAR14A                    ;'|--------------*|' message address
1203 85D4
1204 85D4 D7 88                 DC W:BAR0A                     ;'|*--------------|' message address
1205 85D6 EC 88                 DC W:BAR3A                     ;'|---*-----------|' message address
1206 85D8 0C 89                 DC W:BAR7A                     ;'|-------*-------|' message address
1207 85DA 24 89                 DC W:BAR10A                    ;'|----------*----|' message address
1208 85DC 43 89                 DC W:BAR14A                    ;'|--------------*|' message address
1209 85DE
1210 85DE C4 8D                 DC W:LANGOP10_0A               ;'Normal' message address
1211 85E0 CA 8D                 DC W:LANGOP10_1A               ;'Fast' message address
1212 85E2
1213 85E2
1214 85E2              * Sound Options
1215 85E2
1216 85E2 D7 88                 DC W:BAR0A                     ;'|*--------------|' message address
1217 85E4 DD 88                 DC W:BAR1A                     ;'|-*-------------|' message address
1218 85E6 E4 88                 DC W:BAR2A                     ;'|--*------------|' message address
1219 85E8 EC 88                 DC W:BAR3A                     ;'|---*-----------|' message address
1220 85EA F4 88                 DC W:BAR4A                     ;'|----*----------|' message address
1221 85EC FC 88                 DC W:BAR5A                     ;'|-----*---------|' message address
1222 85EE 04 89                 DC W:BAR6A                     ;'|------*--------|' message address
1223 85F0 0C 89                 DC W:BAR7A                     ;'|-------*-------|' message address
1224 85F2 14 89                 DC W:BAR8A                     ;'|--------*------|' message address
1225 85F4 1C 89                 DC W:BAR9A                     ;'|---------*-----|' message address
1226 85F6 24 89                 DC W:BAR10A                    ;'|----------*----|' message address
1227 85F8 2C 89                 DC W:BAR11A                    ;'|-----------*---|' message address
1228 85FA 34 89                 DC W:BAR12A                    ;'|------------*--|' message address
1229 85FC 3C 89                 DC W:BAR13A                    ;'|-------------*-|' message address
1230 85FE 43 89                 DC W:BAR14A                    ;'|--------------*|' message address
1231 8600
1232 8600
1233 8600              * Clock Options
1234 8600
1235 8600 2A 8E                 DC W:CLOCKOP1_0A               ;'MM/DD/YY' message address
1236 8602 32 8E                 DC W:CLOCKOP1_1A               ;'DD/MM/YY' message address
1237 8604 3A 8E                 DC W:CLOCKOP1_2A               ;'YY/MM/DD' message address
1238 8606
1239 8606 42 8E                 DC W:CLOCKOP2_0A               ;'AM-PM' message address
1240 8608 47 8E                 DC W:CLOCKOP2_1A               ;'24 Hour' message address
1241 860A
1242 860A
1243 860A 4E 8E                 DC W:TURNA                     ;'Turn ' message address
1244 860C 55 8E                 DC W:ALTDSPMODEA               ;'Alternate Display Mode' msg addr
1245 860E 6C 8E                 DC W:ONA                       ;'On' message address
1246 8610 6F 8E                 DC W:OFFA                      ;'Off' message address
1247 8612
1248 8612
1249 8612 73 8E                 DC W:ACCEPTA                   ;'Accept CR' message address
1250 8614
1251 8614
1252 8614 7E 8E                 DC W:WELCOMEA                  ;'Welcome ...' message address
1253 8616
1254 8616
1255 8616 87 7D                 DC W:N1A                       ;Not to be translated test only
1256 8618 8C 7C                 DC W:N2A                       ;Not to be translated, test2 only
1257 861A 70 7B                 DC W:SPLASH1                   ;'Apple IIgs' message address
1258 861C 7D 7B                 DC W:SPLASH2                   ;'Copyright ...' message address
1259 861E A5 7B                 DC W:SPLASH3                   ;Spare splash screen message address
1260 8620 B7 7B                 DC W:SPLASH4                   ;Spare splash screen message address
1261 8622 C7 7B                 DC W:SPLASH5                   ;'All rights ...' message address
1262 8624 DE 7B                 DC W:SPLASH6                   ;'ROM ...' message address
1263 8626
1264 8626              ; if the 10 in the line below is changed a matching 5 in CP_MsgEquates must be changed also
1265 8626 00 00 00 00  SPCLPAD  DC B:10,0                      ;Force to align with cp.tables1     
1266 8630              * Slots Options
1267 8630
1268 8630 D7 8D                 DC W:SLOTSOP1_0A               ;'Printer Port' message address
1269 8632 CE 8D                 DC W:SLOTSOP0_0A               ;'Your Card' message address
1270 8634 15 8E                 DC W:SLOTSOP1_1A               ;'AppleTalk' message address
1271 8636 DE 8D                 DC W:SLOTSOP1_2A               ;'Modem Port' message address
1272 8638
1273 8638 DE 8D                 DC W:SLOTSOP2_0A               ;'Modem Port' message address
1274 863A CE 8D                 DC W:SLOTSOP0_0A               ;'Your Card' message address
1275 863C 15 8E                 DC W:SLOTSOP2_1A               ;'AppleTalk' message address
1276 863E D7 8D                 DC W:SLOTSOP2_2A               ;'Printer Port' message address
1277 8640
1278 8640 E3 8D                 DC W:SLOTSOP3_0A               ;'Built-in Text Display' message address
1279 8642 CE 8D                 DC W:SLOTSOP0_0A               ;'Your Card' message address
1280 8644
1281 8644 F8 8D                 DC W:SLOTSOP4_0A               ;'Built-in Mouse Port' message address
1282 8646 CE 8D                 DC W:SLOTSOP0_0A               ;'Your Card' message address
1283 8648
1284 8648 02 8E                 DC W:SLOTSOP5_0A               ;Built-in Smart Port' message address
1285 864A CE 8D                 DC W:SLOTSOP0_0A               ;'Your Card' message address
1286 864C
1287 864C 0C 8E                 DC W:SLOTSOP6_0A               ;Built-in Disk Port' message address
1288 864E CE 8D                 DC W:SLOTSOP0_0A               ;'Your Card' message address
1289 8650
1290 8650 15 8E                 DC W:SLOTSOP7_0A               ;Built-in SCSI Port' message address
1291 8652 CE 8D                 DC W:SLOTSOP0_0A               ;'Your Card' message address
1292 8654
1293 8654
1294 8654 1E 8E                 DC W:SLOTSOP8_0A               ;'Scan' message address
1295 8656 D8 8A                 DC W:SLOTSOP8_1A               ;'Slot 1' message address
1296 8658 DF 8A                 DC W:SLOTSOP8_2A               ;'Slot 2' message address
1297 865A E6 8A                 DC W:SLOTSOP8_3A               ;'Slot 3' message address
1298 865C ED 8A                 DC W:SLOTSOP8_4A               ;'Slot 4' message address
1299 865E F4 8A                 DC W:SLOTSOP8_5A               ;'Slot 5' message address
1300 8660 FB 8A                 DC W:SLOTSOP8_6A               ;'Slot 6' message address
1301 8662 02 8B                 DC W:SLOTSOP8_7A               ;'Slot 7' message address
1302 8664 8A 89                 DC W:CPLN9A                    ;'Ramdisk' message address
1303 8666 22 8E                 DC W:SLOTSOP8_8A               ;'Romdisk' message address
1304 8668 15 8E                 DC W:SLOTSOP8_9A               ;'AppleTalk' message address
1305 866A
1306 866A
1307 866A
1308 866A
1309 866A                       TITLE 'Control Panel Messages'
1310 866A
1311 866A              ******************************************************
1312 866A              *                                                    *
1313 866A              *      Messages for Control Panel Desk Accessory     *
1314 866A              *                                                    *
1315 866A              *                    by                              *
1316 866A              *               Fern Bachman     1985-1987           *
1317 866A              *               Joe Bo           1987-1989           *
1318 866A              *                                                    *
1319 866A              *      Copyright Apple Computer, Inc. 1985-1989      *
1320 866A              *                All Rights Reserved.                *
1321 866A              *                                                    *
1322 866A              ******************************************************
1323 866A
1324 866A
1325 866A              * Miscellaneous Messages
1326 866A
1327 866A              TIMEMSGA EQU   *
1328 866A 54 69 6D 65           DC I:'Time= '
1329 8670
1330 8670
1331 8670              STEPMSGA EQU   *
1332 8670 53 74 65 F0           DC I:'Step'
1333 8674
1334 8674
1335 8674              TRACEMSGA EQU   *
1336 8674 54 72 61 63           DC I:'Trace'
1337 8679
1338 8679
1339 8679              CBANKMSGA EQU   *
1340 8679 43 62 61 6E           DC I:'Cbank (0/1)'
1341 8684
1342 8684
1343 8684              DECMSGA  EQU   *
1344 8684 44 65 63 69           DC I:'Decimal-> '
1345 868E
1346 868E
1347 868E              HEXMSGA  EQU   *
1348 868E              ARWDASHDOLA EQU   HEXMSGA+3
1349 868E 48 65 78 2D           DC I:'Hex-> $'
1350 8695
1351 8695
1352 8695              TLERRMSGA EQU   *
1353 8695 54 6F 6F 6C           DC I:'Tool error-> '
1354 86A2
1355 86A2
1356 86A2              * Desk Accessory Title
1357 86A2
1358 86A2              CPTITLEA EQU   *
1359 86A2 20 43 6F 6E           DC I:' Control Panel'
1360 86B0
1361 86B0              TOSELUSEA EQU   *
1362 86B0 53 65 6C 65           DC I:'Select:'
1363 86B7
1364 86B7              BOOTMSGA EQU   *
1365 86B7 0E A0                 DC B:14,SPACE                  ;14 spaces to center msg
1366 86B9 C9 AF CF A0           DC B:'I/O error!'
1367 86C3 8D 00                 DC B:CRRETURN,TERMINATOR       ;Carriage return 
1368 86C5
1369 86C5
1370 86C5              DISKMSGA EQU   *
1371 86C5 0A A0                 DC B:10,SPACE                  ;10 spaces to center msg
1372 86C7 CE EF F4 A0           DC B:'Not a startup disk!'
1373 86DA 8D 00                 DC B:CRRETURN,TERMINATOR       ;Cavriage return 
1374 86DC
1375 86DC
1376 86DC              DEVMSGA  EQU   *
1377 86DC 0A A0                 DC B:10,SPACE                  ;10 spaces to center msg
1378 86DE CE EF A0 E4           DC B:'No device connected!'
1379 86F2 8D 00                 DC B:CRRETURN,TERMINATOR       ;Carriage return 
1380 86F4
1381 86F4
1382 86F4              CHKDEVMSGA EQU   *
1383 86F4 0A A0                 DC B:10,SPACE                  ;10 spaces to center msg
1384 86F6 C3 E8 E5 E3           DC B:'Check startup device!'
1385 870B 8D 00                 DC B:CRRETURN,TERMINATOR       ;Carriage return 
1386 870D
1387 870D
1388 870D              SYSDMSGA EQU   *
1389 870D 08 A0                 DC B:8,SPACE                   ;8 spaces to center msg
1390 870F C6 E1 F4 E1           DC B:'Fatal system error-> '
1391 8724              * TERMINATOR is MOUSEIND of next message
1392 8724
1393 8724
1394 8724              TOPBOXA  EQU   *
1395 8724 00 A0                 DC B:MOUSEIND,SPACE
1396 8726 0D DF                 DC B:13,BOTTOMLINE
1397 8728 A0                    DC B:SPACE
1398 8729              * TERMINATOR is MOUSEIND of next message
1399 8729
1400 8729              BOTTOMBOXA EQU   *
1401 8729 00 A0                 DC B:MOUSEIND,SPACE
1402 872B 0D 4C                 DC B:13,TOPLINE
1403 872D A0                    DC B:SPACE                     ;Space hi bit set
1404 872E              * TERMINATOR is MOUSEIND of next message
1405 872E
1406 872E              UDSELA   EQU   *
1407 872E 00                    DC B:MOUSEIND
1408 872F A0 4A A0 4B           DC B:SPACE,DOWNARROW,SPACE,UPARROW
1409 8733              * TERMINATOR is MOUSEIND of next message
1410 8733
1411 8733              LRSELA   EQU   *
1412 8733 00                    DC B:MOUSEIND
1413 8734 A0 48 A0 55           DC B:SPACE,LEFTARROW,SPACE,RIGHTARROW
1414 8738 00                    DC B:TERMINATOR
1415 8739
1416 8739              OPENCRA  EQU   *
1417 8739 12 A0                 DC B:18,SPACE
1418 873B CF F0 E5 EE           DC B:'Open: '
1419 8741 4D 00                 DC B:RETURN,TERMINATOR
1420 8743
1421 8743              SAVECRA  EQU   *
1422 8743 02 A0                 DC B:2,SPACE
1423 8745 D3 E1 F6 E5           DC B:'Save: '
1424 874B 4D 00                 DC B:RETURN,TERMINATOR
1425 874D
1426 874D              CANCELESCA EQU   *
1427 874D 02 A0                 DC B:2,SPACE
1428 874F C3 E1 EE E3           DC B:'Cancel:Esc'
1429 8759              * TERMINATOR is MOUSEIND of next message
1430 8759
1431 8759              SPACEBOXA EQU   *
1432 8759 00 5A                 DC B:MOUSEIND,RIGHTLINE
1433 875B 0D A0                 DC B:13,SPACE
1434 875D 5F                    DC B:LEFTLINE
1435 875E              * TERMINATOR is MOUSEIND of next message
1436 875E
1437 875E              COLORSA  EQU   *
1438 875E 00                    DC B:MOUSEIND
1439 875F 53                    DC B:CENTERLINE
1440 8760 D3 E3 F2 E5           DC B:'Screen Colors'
1441 876D 53                    DC B:CENTERLINE
1442 876E              * TERMINATOR is MOUSEIND of next message
1443 876E
1444 876E              APS1S2L1A EQU   *
1445 876E 00 53                 DC B:MOUSEIND,CENTERLINE
1446 8770              ;ASC 'WARNING: Printer / Modem / AppleTalk'
1447 8770 A0 A0 D7 C1           DC B:'  WARNING: Either Slot 1 or Slot 2  '
1448 8794 53                    DC B:CENTERLINE
1449 8795              * TERMINATOR is MOUSEIND of next message
1450 8795
1451 8795              APS1S2L2A EQU   *
1452 8795 00 53                 DC B:MOUSEIND,CENTERLINE
1453 8797              ;ASC 'cannot be active at the same time!!!'
1454 8797 A0 A0 EE E5           DC B:'  needs to be set to AppleTalk!!!   '
1455 87BB 53                    DC B:CENTERLINE
1456 87BC              * TERMINATOR is MOUSEIND of next message
1457 87BC
1458 87BC              TWOAPTALKA EQU   *
1459 87BC 00 53                 DC B:MOUSEIND,CENTERLINE
1460 87BE D7 C1 D2 CE           DC B:'WARNING:  AppleTalk already Selected'
1461 87E2 53                    DC B:CENTERLINE
1462 87E3              * TERMINATOR IS MOUSEIND of next message
1463 87E3
1464 87E3              ADVANCEDA EQU   *
1465 87E3 00 53                 DC B:MOUSEIND,CENTERLINE
1466 87E5 C1 E4 F6 E1           DC B:'Advanced Features'
1467 87F6 53                    DC B:CENTERLINE
1468 87F7              * TERMINATOR is MOUSEIND of next message
1469 87F7
1470 87F7
1471 87F7              STATUSA  EQU   *
1472 87F7 00 53                 DC B:MOUSEIND,CENTERLINE
1473 87F9 D2 C1 CD A0           DC B:'RAM Status'
1474 8803 53                    DC B:CENTERLINE
1475 8804              * TERMINATOR is MOUSEIND of next message
1476 8804
1477 8804              DISPLN7A EQU   *
1478 8804 00 53                 DC B:MOUSEIND,CENTERLINE
1479 8806 C8 E5 F2 F4           DC B:'Hertz: '
1480 880D              * TERMINATOR is MOUSEIND of next message
1481 880D
1482 880D              RAMDSKLN3A EQU   *
1483 880D 00 53                 DC B:MOUSEIND,CENTERLINE
1484 880F CC E1 F2 E7           DC B:'Largest Selectable:'
1485 8822 04 A0 00              DC B:4,SPACE,TERMINATOR
1486 8825
1487 8825
1488 8825              SPCHOICESA EQU   *
1489 8825 02 A0                 DC B:2,SPACE
1490 8827 B1 BD C5 EE           DC B:'1=Enter the Control Panel.'
1491 8841 8D 8D                 DC B:2,CRRETURN
1492 8843 A0 A0 B2 BD           DC B:'  2=Set system standards and 60 hertz.'
1493 8869 8D 8D                 DC B:2,CRRETURN
1494 886B A0 A0 B3 BD           DC B:'  3=Set system standards and 50 hertz.'
1495 8891 8D 8D                 DC B:CRRETURN,CRRETURN
1496 8893 A0 A0 B4 BD           DC B:'  4=Continue restarting the system.'
1497 88B6 08 8D                 DC B:8,CRRETURN
1498 88B8 05 A0                 DC B:5,SPACE
1499 88BA D0 F2 E5 F3           DC B:'Press 1,2,3 or 4 to continue.'
1500 88D7              * TERMINATOR is MOUSEIND of next message
1501 88D7
1502 88D7
1503 88D7              BAR0A    EQU   *
1504 88D7 00 5A                 DC B:MOUSEIND,RIGHTLINE
1505 88D9 AA                    DC B:'*'
1506 88DA 0E 53                 DC B:14,CENTERLINE
1507 88DC 5F                    DC B:LEFTLINE
1508 88DD              * TERMINATOR is MOUSEIND of next message
1509 88DD
1510 88DD              BAR1A    EQU   *
1511 88DD 00 5A                 DC B:MOUSEIND,RIGHTLINE
1512 88DF 53                    DC B:CENTERLINE
1513 88E0 AA                    DC B:'*'
1514 88E1 0D 53                 DC B:13,CENTERLINE
1515 88E3 5F                    DC B:LEFTLINE
1516 88E4              * TERMINATOR is MOUSEIND of next message
1517 88E4
1518 88E4              BAR2A    EQU   *
1519 88E4 00 5A                 DC B:MOUSEIND,RIGHTLINE
1520 88E6 53 53                 DC B:2,CENTERLINE
1521 88E8 AA                    DC B:'*'
1522 88E9 0C 53                 DC B:12,CENTERLINE
1523 88EB 5F                    DC B:LEFTLINE
1524 88EC              * TERMINATOR is MOUSEIND of next message
1525 88EC
1526 88EC              BAR3A    EQU   *
1527 88EC 00 5A                 DC B:MOUSEIND,RIGHTLINE
1528 88EE 03 53                 DC B:3,CENTERLINE
1529 88F0 AA                    DC B:'*'
1530 88F1 0B 53                 DC B:11,CENTERLINE
1531 88F3 5F                    DC B:LEFTLINE
1532 88F4              * TERMINATOR is MOUSEIND of next message
1533 88F4
1534 88F4              BAR4A    EQU   *
1535 88F4 00 5A                 DC B:MOUSEIND,RIGHTLINE
1536 88F6 04 53                 DC B:4,CENTERLINE
1537 88F8 AA                    DC B:'*'
1538 88F9 0A 53                 DC B:10,CENTERLINE
1539 88FB 5F                    DC B:LEFTLINE
1540 88FC              * TERMINATOR is MOUSEIND of next message
1541 88FC
1542 88FC              BAR5A    EQU   *
1543 88FC 00 5A                 DC B:MOUSEIND,RIGHTLINE
1544 88FE 05 53                 DC B:5,CENTERLINE
1545 8900 AA                    DC B:'*'
1546 8901 09 53                 DC B:9,CENTERLINE
1547 8903 5F                    DC B:LEFTLINE
1548 8904              * TERMINATOR is MOUSEIND of next message
1549 8904
1550 8904              BAR6A    EQU   *
1551 8904 00 5A                 DC B:MOUSEIND,RIGHTLINE
1552 8906 06 53                 DC B:6,CENTERLINE
1553 8908 AA                    DC B:'*'
1554 8909 08 53                 DC B:8,CENTERLINE
1555 890B 5F                    DC B:LEFTLINE
1556 890C              * TERMINATOR is MOUSEIND of next message
1557 890C
1558 890C              BAR7A    EQU   *
1559 890C 00 5A                 DC B:MOUSEIND,RIGHTLINE
1560 890E 07 53                 DC B:7,CENTERLINE
1561 8910 AA                    DC B:'*'
1562 8911 07 53                 DC B:7,CENTERLINE
1563 8913 5F                    DC B:LEFTLINE
1564 8914              * TERMINATOR is MOUSEIND of next message
1565 8914
1566 8914              BAR8A    EQU   *
1567 8914 00 5A                 DC B:MOUSEIND,RIGHTLINE
1568 8916 08 53                 DC B:8,CENTERLINE
1569 8918 AA                    DC B:'*'
1570 8919 06 53                 DC B:6,CENTERLINE
1571 891B 5F                    DC B:LEFTLINE
1572 891C              * TERMINATOR is MOUSEIND of next message
1573 891C
1574 891C              BAR9A    EQU   *
1575 891C 00 5A                 DC B:MOUSEIND,RIGHTLINE
1576 891E 09 53                 DC B:9,CENTERLINE
1577 8920 AA                    DC B:'*'
1578 8921 05 53                 DC B:5,CENTERLINE
1579 8923 5F                    DC B:LEFTLINE
1580 8924              * TERMINATOR is MOUSEIND of next message
1581 8924
1582 8924              BAR10A   EQU   *
1583 8924 00 5A                 DC B:MOUSEIND,RIGHTLINE
1584 8926 0A 53                 DC B:10,CENTERLINE
1585 8928 AA                    DC B:'*'
1586 8929 04 53                 DC B:4,CENTERLINE
1587 892B 5F                    DC B:LEFTLINE
1588 892C              * TERMINATOR is MOUSEIND of next message
1589 892C
1590 892C              BAR11A   EQU   *
1591 892C 00 5A                 DC B:MOUSEIND,RIGHTLINE
1592 892E 0B 53                 DC B:11,CENTERLINE
1593 8930 AA                    DC B:'*'
1594 8931 03 53                 DC B:3,CENTERLINE
1595 8933 5F                    DC B:LEFTLINE
1596 8934              * TERMINATOR is MOUSEIND of next message
1597 8934
1598 8934              BAR12A   EQU   *
1599 8934 00 5A                 DC B:MOUSEIND,RIGHTLINE
1600 8936 0C 53                 DC B:12,CENTERLINE
1601 8938 AA                    DC B:'*'
1602 8939 53 53                 DC B:2,CENTERLINE
1603 893B 5F                    DC B:LEFTLINE
1604 893C              * TERMINATOR is MOUSEIND of next message
1605 893C
1606 893C              BAR13A   EQU   *
1607 893C 00 5A                 DC B:MOUSEIND,RIGHTLINE
1608 893E 0D 53                 DC B:13,CENTERLINE
1609 8940 AA                    DC B:'*'
1610 8941 53                    DC B:CENTERLINE
1611 8942 5F                    DC B:LEFTLINE
1612 8943              * TERMINATOR is MOUSEIND of next message
1613 8943
1614 8943              BAR14A   EQU   *
1615 8943 00 5A                 DC B:MOUSEIND,RIGHTLINE
1616 8945 0E 53                 DC B:14,CENTERLINE
1617 8947 AA                    DC B:'*'
1618 8948 5F 00                 DC B:LEFTLINE,TERMINATOR
1619 894A
1620 894A              * TERMINATOR is MOUSEIND of next message
1621 894A
1622 894A
1623 894A              * Main Menu
1624 894A
1625 894A              CPLN1A   EQU   *
1626 894A 44 69 73 70           DC I:'Display'
1627 8951              CPLN2A   EQU   *
1628 8951 53 6F 75 6E           DC I:'Sound'
1629 8956              CPLN3A   EQU   *
1630 8956 53 79 73 74           DC I:'System Speed'
1631 8962              CPLN4A   EQU   *
1632 8962 43 6C 6F 63           DC I:'Clock'
1633 8967              CPLN5A   EQU   *
1634 8967 4B 65 79 62           DC I:'Keyboard'
1635 896F              CPLN6A   EQU   *
1636 896F 53 6C 6F 74           DC I:'Slots'
1637 8974              CPLN7A   EQU   *
1638 8974 50 72 69 6E           DC I:'Printer Port'
1639 8980              CPLN8A   EQU   *
1640 8980 4D 6F 64 65           DC I:'Modem Port'
1641 898A              CPLN9A   EQU   *
1642 898A 52 41 4D 20           DC I:'RAM Disk'
1643 8992              CPLN10A  EQU   *
1644 8992 51 75 69 F4           DC I:'Quit'
1645 8996              CPLN11A  EQU   *
1646 8996 4D 6F 75 73           DC I:'Mouse'
1647 899B
1648 899B
1649 899B              * Serial Port
1650 899B
1651 899B              SERIALLN1A EQU   *
1652 899B 2D 44 65 76           DC I:'-Device Connected'
1653 89AC              SERIALLN2A EQU   *
1654 89AC 4C 69 6E 65           DC I:'Line Length'
1655 89B7              SERIALLN3A EQU   *
1656 89B7 44 65 6C 65           DC I:'Delete first LF after CR'
1657 89CF              SERIALLN4A EQU   *
1658 89CF 41 64 64 20           DC I:'Add LF after CR'
1659 89DE              SERIALLN5A EQU   *
1660 89DE 45 63 68 EF           DC I:'Echo'
1661 89E2              SERIALLN6A EQU   *
1662 89E2 42 75 66 66           DC I:'Buffering'
1663 89EB              SERIALLN7A EQU   *
1664 89EB 42 61 75 E4           DC I:'Baud'
1665 89EF              SERIALLN8A EQU   *
1666 89EF 44 61 74 61           DC I:'Data/Stop Bits'
1667 89FD              SERIALLN9A EQU   *
1668 89FD 50 61 72 69           DC I:'Parity'
1669 8A03              SERIALLN10A EQU   *
1670 8A03 44 43 44 20           DC I:'DCD Handshake'
1671 8A10              SERIALLN11A EQU   *
1672 8A10 44 53 52 2F           DC I:'DSR/DTR Handshake'
1673 8A21              SERIALLN12A EQU   *
1674 8A21 58 4F 4E 2F           DC I:'XON/XOFF Handshake'
1675 8A33
1676 8A33
1677 8A33              * Display
1678 8A33
1679 8A33              DISPLN1A EQU   *
1680 8A33 54 79 70 E5           DC I:'Type'
1681 8A37              DISPLN2A EQU   *
1682 8A37 43 6F 6C 75           DC I:'Columns'
1683 8A3E              DISPLN3A EQU   *
1684 8A3E 54 65 78 F4           DC I:'Text'
1685 8A42              DISPLN4A EQU   *
1686 8A42 42 61 63 6B           DC I:'Background'
1687 8A4C              DISPLN5A EQU   *
1688 8A4C 42 6F 72 64           DC I:'Border'
1689 8A52              DISPLN6A EQU   *
1690 8A52 53 74 61 6E           DC I:'Standards'
1691 8A5B              DISPOPC0A EQU   *
1692 8A5B 42 6C 61 63           DC I:'Black'
1693 8A60              DISPOPC1A EQU   *
1694 8A60 44 65 65 70           DC I:'Deep Red'
1695 8A68              DISPOPC2A EQU   *
1696 8A68 44 61 72 6B           DC I:'Dark Blue'
1697 8A71              DISPOPC3A EQU   *
1698 8A71 50 75 72 70           DC I:'Purple'
1699 8A77              DISPOPC4A EQU   *
1700 8A77 44 61 72 6B           DC I:'Dark Green'
1701 8A81              DISPOPC5A EQU   *
1702 8A81 44 61 72 6B           DC I:'Dark Gray'
1703 8A8A              DISPOPC6A EQU   *
1704 8A8A 4D 65 64 69           DC I:'Medium Blue'
1705 8A95              DISPOPC7A EQU   *
1706 8A95 4C 69 67 68           DC I:'Light Blue'
1707 8A9F              DISPOPC8A EQU   *
1708 8A9F 42 72 6F 77           DC I:'Brown'
1709 8AA4              DISPOPC9A EQU   *
1710 8AA4 4F 72 61 6E           DC I:'Orange'
1711 8AAA              DISPOPC10A EQU   *
1712 8AAA 4C 69 67 68           DC I:'Light Gray'
1713 8AB4              DISPOPC11A EQU   *
1714 8AB4 50 69 6E EB           DC I:'Pink'
1715 8AB8              DISPOPC12A EQU   *
1716 8AB8 4C 69 67 68           DC I:'Light Green'
1717 8AC3              DISPOPC13A EQU   *
1718 8AC3 59 65 6C 6C           DC I:'Yellow'
1719 8AC9              DISPOPC14A EQU   *
1720 8AC9 41 71 75 61           DC I:'Aquamarine'
1721 8AD3              DISPOPC15A EQU   *
1722 8AD3 57 68 69 74           DC I:'White'
1723 8AD8
1724 8AD8
1725 8AD8              * Slots
1726 8AD8
1727 8AD8              SLOTSLN1A EQU   *
1728 8AD8              SLOTSOP8_1A EQU   *
1729 8AD8 53 6C 6F 74           DC I:'Slot 1'
1730 8ADE 00                    DC B:TERMINATOR
1731 8ADF
1732 8ADF              SLOTSLN2A EQU   *
1733 8ADF              SLOTSOP8_2A EQU   *
1734 8ADF 53 6C 6F 74           DC I:'Slot 2'
1735 8AE5 00                    DC B:TERMINATOR
1736 8AE6
1737 8AE6              SLOTSLN3A EQU   *
1738 8AE6              SLOTSOP8_3A EQU   *
1739 8AE6 53 6C 6F 74           DC I:'Slot 3'
1740 8AEC 00                    DC B:TERMINATOR
1741 8AED
1742 8AED              SLOTSLN4A EQU   *
1743 8AED              SLOTSOP8_4A EQU   *
1744 8AED 53 6C 6F 74           DC I:'Slot 4'
1745 8AF3 00                    DC B:TERMINATOR
1746 8AF4
1747 8AF4              SLOTSLN5A EQU   *
1748 8AF4              SLOTSOP8_5A EQU   *
1749 8AF4 53 6C 6F 74           DC I:'Slot 5'
1750 8AFA 00                    DC B:TERMINATOR
1751 8AFB
1752 8AFB              SLOTSLN6A EQU   *
1753 8AFB              SLOTSOP8_6A EQU   *
1754 8AFB 53 6C 6F 74           DC I:'Slot 6'
1755 8B01 00                    DC B:TERMINATOR
1756 8B02
1757 8B02              SLOTSLN7A EQU   *
1758 8B02              SLOTSOP8_7A EQU   *
1759 8B02 53 6C 6F 74           DC I:'Slot 7'
1760 8B08 00                    DC B:TERMINATOR
1761 8B09
1762 8B09              SLOTSLN8A EQU   *
1763 8B09 53 74 61 72           DC I:'StartUp'
1764 8B10
1765 8B10
1766 8B10              * Options
1767 8B10
1768 8B10              LANGLN1A EQU   *
1769 8B10 44 69 73 70           DC I:'Display Language'
1770 8B20              LANGLN2A EQU   *
1771 8B20 4B 65 79 62           DC I:'Keyboard Layout'
1772 8B2F              LANGLN3A EQU   *
1773 8B2F 4B 65 79 62           DC I:'Keyboard Buffering'
1774 8B41              LANGLN4A EQU   *
1775 8B41 52 65 70 65           DC I:'Repeat Speed'
1776 8B4D              LANGLN5A EQU   *
1777 8B4D 52 65 70 65           DC I:'Repeat Delay'
1778 8B59              ;LANGLN6A EQU *
1779 8B59              ;DCI 'Double Click'
1780 8B59              LANGLN7A EQU   *
1781 8B59 43 75 72 73           DC I:'Cursor Flash'
1782 8B65              LANGLN8A EQU   *
1783 8B65 53 68 69 66           DC I:'Shift Caps/Lowercase'
1784 8B79              LANGLN9A EQU   *
1785 8B79 46 61 73 74           DC I:'Fast Space/Delete Keys'
1786 8B8F              LANGLN10A EQU   *
1787 8B8F 44 75 61 6C           DC I:'Dual Speed Keys'
1788 8B9E
1789 8B9E
1790 8B9E              * Clock
1791 8B9E
1792 8B9E              CLOCKLN1A EQU   *
1793 8B9E 4D 6F 6E 74           DC I:'Month'
1794 8BA3              CLOCKLN2A EQU   *
1795 8BA3 44 61 F9              DC I:'Day'
1796 8BA6              CLOCKLN3A EQU   *
1797 8BA6 59 65 61 F2           DC I:'Year'
1798 8BAA              CLOCKLN4A EQU   *
1799 8BAA 46 6F 72 6D           DC I:'Format'
1800 8BB0              CLOCKLN6A EQU   *
1801 8BB0 48 6F 75 F2           DC I:'Hour'
1802 8BB4              CLOCKLN7A EQU   *
1803 8BB4 4D 69 6E 75           DC I:'Minute'
1804 8BBA              CLOCKLN8A EQU   *
1805 8BBA 53 65 63 6F           DC I:'Second'
1806 8BC0
1807 8BC0
1808 8BC0              * RAM Disk
1809 8BC0
1810 8BC0              RAMDSKLN1A EQU   *
1811 8BC0 53 65 6C 65           DC I:'Select RAM  Disk  Size'
1812 8BD6              ;RAMDSKLN2A EQU *
1813 8BD6              ;DCI 'Maximum RAM Disk Size'
1814 8BD6              RAMDSKLN4A EQU   *
1815 8BD6                       MSB   OFF                      ;Create DCI type ASCII string
1816 8BD6 52 41 4D 20           DC B:'RAM Disk Size:'
1817 8BE4                       MSB   ON
1818 8BE4 09 20 A0              DC B:9,INVSPACE,SPACE
1819 8BE7
1820 8BE7              RAMDSKLN5A EQU   *
1821 8BE7                       MSB   OFF                      ;Create DCI type ASGII string
1822 8BE7 54 6F 74 61           DC B:'Total RAM in Use:'
1823 8BF8                       MSB   ON
1824 8BF8 06 20 A0              DC B:6,INVSPACE,SPACE
1825 8BFB
1826 8BFB              RAMDSKLN6A EQU   *
1827 8BFB                       MSB   OFF                      ;Create DCI type ASCII string
1828 8BFB 54 6F 74 61           DC B:'Total Free RAM:'
1829 8C0A                       MSB   ON
1830 8C0A              SPACEA   EQU   *+1                      ;Catch $20,$A0 from message
1831 8C0A 08 20 A0              DC B:8,INVSPACE,SPACE
1832 8C0D              RAMDSKLN7A EQU   *
1833 8C0D 52 65 73 69           DC I:'Resize after Reset'
1834 8C1F
1835 8C1F
1836 8C1F              * Sound
1837 8C1F
1838 8C1F              SOUNDLN1A EQU   *
1839 8C1F 56 6F 6C 75           DC I:'Volume'
1840 8C25              SOUNDLN2A EQU   *
1841 8C25 20 50 69 74           DC I:' Pitch'
1842 8C2B
1843 8C2B              * Mouse
1844 8C2B
1845 8C2B              MOUSELN1A EQU   *
1846 8C2B 4D 6F 75 73           DC I:'Mouse Tracking'
1847 8C39              MOUSELN2A EQU   *
1848 8C39 44 6F 75 62           DC I:'Double Click  '
1849 8C47              MOUSELN3A EQU   *
1850 8C47 44 65 6C 61           DC I:'Delay-to-Start'
1851 8C55              MOUSELN4A EQU   *
1852 8C55 41 63 63 65           DC I:'Acceleration  '
1853 8C63              MOUSELN5A EQU   *
1854 8C63 4D 61 78 69           DC I:'Maximum Speed '
1855 8C71              ADVMSEMSGA EQU   *
1856 8C71 2D 4B 65 79           DC I:'-Keyboard Mouse-'
1857 8C81
1858 8C81                       EJECT 
1859 8C81              * Serial Port Options
1860 8C81
1861 8C81              PORTOP1_0A EQU   *
1862 8C81 50 72 69 6E           DC I:'Printer-'
1863 8C89              PORTOP1_1A EQU   *
1864 8C89 4D 6F 64 65           DC I:'Modem-'
1865 8C8F              PORTOP1_2A EQU   *
1866 8C8F 41 70 70 6C           DC I:'AppleTalk-'
1867 8C99              PORTOP1_3A EQU   *
1868 8C99 59 6F 75 72           DC I:'Your Card-'
1869 8CA3
1870 8CA3              PORTOP2_0A EQU   *
1871 8CA3 55 6E 6C 69           DC I:'Unlimited'
1872 8CAC              PORTOP2_1A EQU   *
1873 8CAC 34 B0                 DC I:'40'
1874 8CAE              PORTOP2_2A EQU   *
1875 8CAE 37 B2                 DC I:'72'
1876 8CB0              PORTOP2_3A EQU   *
1877 8CB0 38 B0                 DC I:'80'
1878 8CB2              PORTOP2_4A EQU   *
1879 8CB2 31 33 B2              DC I:'132'
1880 8CB5
1881 8CB5              PORTOP3_0A EQU   *
1882 8CB5 4E EF                 DC I:'No'
1883 8CB7              PORTOP3_1A EQU   *
1884 8CB7 59 65 F3              DC I:'Yes'
1885 8CBA
1886 8CBA              PORTOP7_0A EQU   *
1887 8CBA 35 B0                 DC I:'50'
1888 8CBC              PORTOP7_1A EQU   *
1889 8CBC 37 B5                 DC I:'75'
1890 8CBE              PORTOP7_2A EQU   *
1891 8CBE 31 31 B0              DC I:'110'
1892 8CC1              PORTOP7_3A EQU   *
1893 8CC1 31 33 34 2E           DC I:'134.5'
1894 8CC6              PORTOP7_4A EQU   *
1895 8CC6 31 35 B0              DC I:'150'
1896 8CC9              PORTOP7_5A EQU   *
1897 8CC9 33 30 B0              DC I:'300'
1898 8CCC              PORTOP7_6A EQU   *
1899 8CCC 36 30 B0              DC I:'600'
1900 8CCF              PORTOP7_7A EQU   *
1901 8CCF 31 32 30 B0           DC I:'1200'
1902 8CD3              PORTOP7_8A EQU   *
1903 8CD3 31 38 30 B0           DC I:'1800'
1904 8CD7              PORTOP7_9A EQU   *
1905 8CD7 32 34 30 B0           DC I:'2400'
1906 8CDB              PORTOP7_10A EQU   *
1907 8CDB 33 36 30 B0           DC I:'3600'
1908 8CDF              PORTOP7_11A EQU   *
1909 8CDF 34 38 30 B0           DC I:'4800'
1910 8CE3              PORTOP7_12A EQU   *
1911 8CE3 37 32 30 B0           DC I:'7200'
1912 8CE7              PORTOP7_13A EQU   *
1913 8CE7 39 36 30 B0           DC I:'9600'
1914 8CEB              PORTOP7_14A EQU   *
1915 8CEB 31 39 32 30           DC I:'19200'
1916 8CF0
1917 8CF0              PORTOP8_0A EQU   *
1918 8CF0 35 2F B1              DC I:'5/1'
1919 8CF3              PORTOP8_1A EQU   *
1920 8CF3 35 2F B2              DC I:'5/2'
1921 8CF6              PORTOP8_2A EQU   *
1922 8CF6 36 2F B1              DC I:'6/1'
1923 8CF9              PORTOP8_3A EQU   *
1924 8CF9 36 2F B2              DC I:'6/2'
1925 8CFC              PORTOP8_4A EQU   *
1926 8CFC 37 2F B1              DC I:'7/1'
1927 8CFF              PORTOP8_5A EQU   *
1928 8CFF 37 2F B2              DC I:'7/2'
1929 8D02              PORTOP8_6A EQU   *
1930 8D02 38 2F B1              DC I:'8/1'
1931 8D05              PORTOP8_7A EQU   *
1932 8D05 38 2F B2              DC I:'8/2'
1933 8D08
1934 8D08              PORTOP9_0A EQU   *
1935 8D08 4F 64 E4              DC I:'Odd'
1936 8D0B              PORTOP9_1A EQU   *
1937 8D0B 45 76 65 EE           DC I:'Even'
1938 8D0F              PORTOP9_2A EQU   *
1939 8D0F 4E 6F 6E E5           DC I:'None'
1940 8D13
1941 8D13
1942 8D13              * Display Options
1943 8D13
1944 8D13              DISPOP1_0A EQU   *
1945 8D13 43 6F 6C 6F           DC I:'Color'
1946 8D18              DISPOP1_1A EQU   *
1947 8D18 4D 6F 6E 6F           DC I:'Monochrome'
1948 8D22
1949 8D22              DISPOP3_0A EQU   *
1950 8D22 36 B0                 DC I:'60'
1951 8D24
1952 8D24
1953 8D24              * Language Options
1954 8D24
1955 8D24              LANGOP1_0A EQU   *
1956 8D24 55 2E 53 2E           DC I:'U.S.A.'
1957 8D2A              LANGOP1_1A EQU   *
1958 8D2A 55 2E 4B AE           DC I:'U.K.'
1959 8D2E              LANGOP1_2A EQU   *
1960 8D2E 46 72 65 6E           DC I:'French'
1961 8D34              LANGOP1_3A EQU   *
1962 8D34 44 61 6E 69           DC I:'Danish'
1963 8D3A              LANGOP1_4A EQU   *
1964 8D3A 53 70 61 6E           DC I:'Spanish'
1965 8D41              LANGOP1_5A EQU   *
1966 8D41 49 74 61 6C           DC I:'Italian'
1967 8D48              LANGOP1_6A EQU   *
1968 8D48 47 65 72 6D           DC I:'German'
1969 8D4E              LANGOP1_7A EQU   *
1970 8D4E 53 77 65 64           DC I:'Swedish'
1971 8D55              LANGOP1_8A EQU   *
1972 8D55 44 76 6F 72           DC I:'Dvorak'
1973 8D5B              LANGOP1_9A EQU   *
1974 8D5B 46 72 65 6E           DC I:'French Canadian'
1975 8D6A              LANGOP1_10A EQU   *
1976 8D6A 46 6C 65 6D           DC I:'Flemish'
1977 8D71              LANGOP1_11A EQU   *
1978 8D71 48 65 62 72           DC I:'Hebrew'
1979 8D77              LANGOP1_12A EQU   *
1980 8D77 4A 61 70 61           DC I:'Japanese'
1981 8D7F              LANGOP1_13A EQU   *
1982 8D7F 41 72 61 62           DC I:'Arabic'
1983 8D85              LANGOP1_14A EQU   *
1984 8D85 47 72 65 65           DC I:'Greek'
1985 8D8A              LANGOP1_15A EQU   *
1986 8D8A 54 75 72 6B           DC I:'Turkish'
1987 8D91              LANGOP1_16A EQU   *
1988 8D91 46 69 6E 6E           DC I:'Finnish'
1989 8D98              LANGOP1_17A EQU   *
1990 8D98 50 6F 72 74           DC I:'Portuguese'
1991 8DA2              LANGOP1_18A EQU   *
1992 8DA2 54 61 6D 69           DC I:'Tamil'
1993 8DA7              LANGOP1_19A EQU   *
1994 8DA7 48 69 6E 64           DC I:'Hindu'
1995 8DAC              LANGOP1_20A EQU   *
1996 8DAC 54 B1                 DC I:'T1'
1997 8DAE              LANGOP1_21A EQU   *
1998 8DAE 54 B2                 DC I:'T2'
1999 8DB0              LANGOP1_22A EQU   *
2000 8DB0 54 B3                 DC I:'T3'
2001 8DB2              LANGOP1_23A EQU   *
2002 8DB2 54 B4                 DC I:'T4'
2003 8DB4              LANGOP1_24A EQU   *
2004 8DB4 54 B5                 DC I:'T5'
2005 8DB6              LANGOP1_25A EQU   *
2006 8DB6 54 B6                 DC I:'T6'
2007 8DB8              LANGOP1_26A EQU   *
2008 8DB8 4C B1                 DC I:'L1'
2009 8DBA              LANGOP1_27A EQU   *
2010 8DBA 4C B2                 DC I:'L2'
2011 8DBC              LANGOP1_28A EQU   *
2012 8DBC 4C B3                 DC I:'L3'
2013 8DBE              LANGOP1_29A EQU   *
2014 8DBE 4C B4                 DC I:'L4'
2015 8DC0              LANGOP1_30A EQU   *
2016 8DC0 4C B5                 DC I:'L5'
2017 8DC2              LANGOP1_31A EQU   *
2018 8DC2 4C B6                 DC I:'L6'
2019 8DC4
2020 8DC4              LANGOP10_0A EQU   *
2021 8DC4 4E 6F 72 6D           DC I:'Normal'
2022 8DCA              LANGOP10_1A EQU   *
2023 8DCA 46 61 73 F4           DC I:'Fast'
2024 8DCE
2025 8DCE
2026 8DCE              * Slots Options
2027 8DCE
2028 8DCE              SLOTSOP0_0A EQU   *
2029 8DCE 59 6F 75 72           DC I:'Your Card'
2030 8DD7
2031 8DD7              SLOTSOP1_0A EQU   *
2032 8DD7              SLOTSOP2_2A EQU   *
2033 8DD7 50 72 69 6E           DC I:'Printer'
2034 8DDE
2035 8DDE              SLOTSOP2_0A EQU   *
2036 8DDE              SLOTSOP1_2A EQU   *
2037 8DDE 4D 6F 64 65           DC I:'Modem'
2038 8DE3
2039 8DE3              SLOTSOP3_0A EQU   *
2040 8DE3 42 75 69 6C           DC I:'Built-in Text Display'
2041 8DF8
2042 8DF8              SLOTSOP4_0A EQU   *
2043 8DF8 4D 6F 75 73           DC I:'Mouse Port'
2044 8E02
2045 8E02              SLOTSOP5_0A EQU   *
2046 8E02 53 6D 61 72           DC I:'Smart Port'
2047 8E0C
2048 8E0C              SLOTSOP6_0A EQU   *
2049 8E0C 44 69 73 6B           DC I:'Disk Port'
2050 8E15
2051 8E15              SLOTSOP7_0A EQU   *
2052 8E15              SLOTSOP8_9A EQU   *
2053 8E15              SLOTSOP2_1A EQU   *
2054 8E15              SLOTSOP1_1A EQU   *
2055 8E15              ;DCI 'Built-in SCSI'
2056 8E15 41 70 70 6C           DC I:'AppleTalk'
2057 8E1E
2058 8E1E              SLOTSOP8_0A EQU   *
2059 8E1E 53 63 61 EE           DC I:'Scan'
2060 8E22
2061 8E22              SLOTSOP8_8A EQU   *
2062 8E22 52 4F 4D 20           DC I:'ROM Disk'
2063 8E2A
2064 8E2A
2065 8E2A              * Clock Options
2066 8E2A
2067 8E2A              CLOCKOP1_0A EQU   *
2068 8E2A 4D 4D 2F 44           DC I:'MM/DD/YY'
2069 8E32              CLOCKOP1_1A EQU   *
2070 8E32 44 44 2F 4D           DC I:'DD/MM/YY'
2071 8E3A              CLOCKOP1_2A EQU   *
2072 8E3A 59 59 2F 4D           DC I:'YY/MM/DD'
2073 8E42
2074 8E42              CLOCKOP2_0A EQU   *
2075 8E42 41 4D 2D 50           DC I:'AM-PM'
2076 8E47              CLOCKOP2_1A EQU   *
2077 8E47 32 34 20 48           DC I:'24 Hour'
2078 8E4E
2079 8E4E
2080 8E4E              TURNA    EQU   *
2081 8E4E 03 A0                 DC B:3,SPACE
2082 8E50 D4 F5 F2 EE           DC B:'Turn'
2083 8E54 00                    DC B:TERMINATOR
2084 8E55
2085 8E55              ALTDSPMODEA EQU   *
2086 8E55 20 41 6C 74           DC I:' Alternate Display Mode'
2087 8E6C
2088 8E6C              ONA      EQU   *
2089 8E6C 20 4F EE              DC I:' On'
2090 8E6F
2091 8E6F              OFFA     EQU   *
2092 8E6F 20 4F 66 E6           DC I:' Off'
2093 8E73
2094 8E73              ACCEPTA  EQU   *
2095 8E73 10 A0                 DC B:16,SPACE
2096 8E75 C1 E3 E3 E5           DC B:'Accept '
2097 8E7C 4D 00                 DC B:RETURN,TERMINATOR
2098 8E7E
2099 8E7E
2100 8E7E              WELCOMEA EQU   *
2101 8E7E 57 65 6C 63           DC I:'Welcome...Control-Y Return exits'
2102 8E9E
2103 8E9E
2104 8E9E              CPLEN    EQU   *-MSGTBL
2105 8E9E
2106 8E9E
